/**
 * Project Name:ssp-center-api
 * File Name:ReqCashParam.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年5月4日下午9:15:27
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * ClassName:ReqCashParam <br/>
 * Function: 请求提现参数. <br/>
 * Date:     2017年5月4日 下午9:15:27 <br/>
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqCashParam implements Serializable {

    /**序列号*/
    private static final long serialVersionUID = -7918883536431233741L;

    /**提现金额*/
    @ApiModelProperty(value = "提现金额", required = false)
    private Long cashAmount;

    /**联系人*/
    @ApiModelProperty(value = "联系人", required = true)
    @NotBlank(message = "联系人为空")
    private String linkMan;

    /**联系电话*/
    @ApiModelProperty(value = "联系电话", required = true)
    @NotBlank(message = "联系电话为空")
    private String linkPhone;

    /**寄件人地址*/
    @ApiModelProperty(value = "寄件人地址", required = true)
    @NotBlank(message = "寄件人地址为空")
    private String senderAddress;

    /**寄件类型*/
    private Integer sendType;

    /**媒体提现单发票信息*/
    @Valid
    @ApiModelProperty(value = "媒体提现单发票信息", required = true)
//    @NotEmpty(message = "媒体提现单发票信息为空")
    private List<BaseCashBillDto> invoicesList;

    /**媒体应用IDS*/
    @ApiModelProperty(value = "媒体应用IDS", required = true)
    //@NotEmpty(message = "媒体应用IDS为空")
    private List<Long> appIds;

    /**账单月份集合*/
    @ApiModelProperty(value = "账单月份集合IDS", required = true)
    private List<String> curDates;

    @ApiModelProperty(value = "媒体激励月数据IDS（勾选时不能为空）", required = true)
    private List<Long> mrmIds;

    /**发票数量*/
    private Integer invoiceNum;

    /**媒体用户ID*/
    private Long mediaId;

    /**提现订单*/
    private Long cashOrderId;

    /**所填发票金额*/
    @ApiModelProperty(value = "所填发票金额", required = true)
    @NotNull(message = "所填发票金额为空")
    private Long fillInAmount;


    /**是否需要回寄结算单*/
    private Integer needBackSettlement;

    /**月账单ids*/
    private List<Long> monthBillIds;

    /** 预付款Id集合 */
    @ApiModelProperty(value = "预付款Id集合", required = false)
    private List<Long> prePayIds;

    //是否是预付款用户,无需前台传递参数
    private Integer prePayAccountStatus;

    //0:杭州 1:霍尔果斯 2:霍城兑捷
    /**
     * @see cn.com.duiba.tuia.ssp.center.api.constant.TuiaCompanyType
     */
    private int companyType;
    
    private Integer billStatus;

    @ApiModelProperty(value = "结算单类型(2为预付款结算单)", required = true)
    private Integer orderType;

    public List<Long> getMrmIds() {
        return mrmIds;
    }

    public void setMrmIds(List<Long> mrmIds) {
        this.mrmIds = mrmIds;
    }

    public Long getFillInAmount() {
        return fillInAmount;
    }

    public void setFillInAmount(Long fillInAmount) {
        this.fillInAmount = fillInAmount;
    }


    public Long getMediaId() {
        return mediaId;
    }


    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }


    public Long getCashAmount() {
        return cashAmount;
    }


    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }


    public String getLinkMan() {
        return linkMan;
    }


    public void setLinkMan(String linkMan) {
        this.linkMan = linkMan;
    }


    public String getLinkPhone() {
        return linkPhone;
    }


    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }


    public String getSenderAddress() {
        return senderAddress;
    }


    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }


    public Integer getSendType() {
        return sendType;
    }


    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }


    public Integer getInvoiceNum() {
        return invoiceNum;
    }


    public void setInvoiceNum(Integer invoiceNum) {
        this.invoiceNum = invoiceNum;
    }


    public Long getCashOrderId() {
        return cashOrderId;
    }


    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }

    public List<BaseCashBillDto> getInvoicesList() {
        return invoicesList;
    }

    public void setInvoicesList(List<BaseCashBillDto> invoicesList) {
        this.invoicesList = invoicesList;
    }

    public List<Long> getAppIds() {
        return appIds;
    }


    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public List<String> getCurDates() {
        return curDates;
    }


    public void setCurDates(List<String> curDates) {
        this.curDates = curDates;
    }

    public Integer getNeedBackSettlement() {
        return needBackSettlement;
    }


    public void setNeedBackSettlement(Integer needBackSettlement) {
        this.needBackSettlement = needBackSettlement;
    }

    public List<Long> getMonthBillIds() {
        return monthBillIds;
    }


    public void setMonthBillIds(List<Long> monthBillIds) {
        this.monthBillIds = monthBillIds;
    }

    public List<Long> getPrePayIds() {
        return prePayIds;
    }

    public void setPrePayIds(List<Long> prePayIds) {
        this.prePayIds = prePayIds;
    }

    public Integer getPrePayAccountStatus() {
        return prePayAccountStatus;
    }

    public void setPrePayAccountStatus(Integer prePayAccountStatus) {
        this.prePayAccountStatus = prePayAccountStatus;
    }

    public int getCompanyType() {
        return companyType;
    }

    public void setCompanyType(int companyType) {
        this.companyType = companyType;
    }
    
    public Integer getBillStatus() {
        return billStatus;
    }

    
    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

