package cn.com.duiba.tuia.subscribe.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.subscribe.api.dto.OperatorDto;
import cn.com.duiba.tuia.subscribe.api.dto.PageDto;
import cn.com.duiba.tuia.subscribe.api.dto.PutPlanDto;
import cn.com.duiba.tuia.subscribe.api.dto.PutPlanQueryParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * <p>
 * 计划表 前端控制器
 * </p>
 *
 * @author hong
 * @since 2024/03/05
 */
@AdvancedFeignClient
public interface RemotePutPlanService{
    /**
     * 添加计划
     * @param req
     * @param result
     * @return
     */
    Boolean addPlan(PutPlanDto req) throws BizException;

    /**
     * 编辑计划
     * @param req
     * @param result
     * @return
     */
    Boolean editPlan(PutPlanDto req) throws BizException;

    /**
     * 查询计划详情
     * @param id
     * @return
     */
    PutPlanDto queryDetail(Long id) throws BizException;

    /**
     * 查询计划列表
     * @return
     */
   PageDto<PutPlanDto> listPlan(PutPlanQueryParam param);

    /**
     * 删除产品
     * @return
     */
    Boolean delPlan(Long id) throws BizException;
}
