package cn.com.duiba.tuia.subscribe.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * Created by hong
 * time 2024/3/14.
 */
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
public class BasicOrderDto extends BasicHttpDto implements Serializable {

    /**
     * 积木id
     */
    private String pageId;

    /**
     * 推啊订单号
     */
    private String outOrderNo;

    /**
     * 运营商订单号
     */
    private String orderNo;

    /**
     * 运营商订单状态
     */
    private String orderStatus;

    /**
     * 推啊订单状态
     */
    private Integer tuiaOrderStatus;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订购响应码
     */
    private String orderErrorCode;

    /**
     * 订购响应码描述
     */
    private String orderErrorMsg;

    @Builder(toBuilder = true)
    public BasicOrderDto(String reqStr,
                         String reqHeader,
                         String resStr,
                         String reqUrl,
                         Integer advertCode,
                         String pageId,
                         String outOrderNo,
                         String orderNo,
                         String orderStatus,
                         Integer tuiaOrderStatus,
                         Long orderTime,
                         String orderErrorCode,
                         String orderErrorMsg) {
        super(reqStr, reqHeader, resStr, reqUrl, advertCode);
        this.pageId = pageId;
        this.outOrderNo = outOrderNo;
        this.orderNo = orderNo;
        this.orderStatus = orderStatus;
        this.tuiaOrderStatus = tuiaOrderStatus;
        this.orderTime = orderTime;
        this.orderErrorCode = orderErrorCode;
        this.orderErrorMsg = orderErrorMsg;
    }
}
