package cn.com.duiba.tuia.subscribe.api.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2023/12/21.
 */
public class PageDto<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = -5219671120762356693L;

    /** 每页数量 */
    private int               pageSize;

    /** 总数. */
    private int               totalCount;

    /** 总页数. */
    private int               totalPage;

    /** 当前页 */
    private int               currentPage;

    /** 偏移量 */
    private int               offset;

    /** 每页数量 */
    private int               max;

    /** The data. */
    private List<T> list;

    /**
     * Creates a new instance of PageResultDto.
     */
    public PageDto() {

    }

    /**
     * Creates a new instance of PageDto.
     *
     * @param totalAmount 总数
     * @param list 数据
     * @param offset 偏移值
     * @param max 页最大数量
     */
    public PageDto(int totalAmount, List<T> list, int offset, int max) {
        this.totalCount = totalAmount;
        this.list = list;
        this.offset = offset;
        this.max = max;
        this.pageSize = max;
        this.currentPage = offset / max + 1;
        this.totalPage = calTotalPage(pageSize);
    }

    /**
     * Creates a new instance of PageDto.
     *
     * @param currentPage
     * @param pageSize
     */
    public PageDto(int currentPage, int pageSize) {
        this.max = pageSize;
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.offset = pageSize * (currentPage - 1);
    }

    public PageDto(int currentPage, int pageSize, int totalCount) {
        this.totalCount = totalCount;
        this.max = pageSize;
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.offset = pageSize * (currentPage - 1);
        this.totalPage = calTotalPage(pageSize);
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private int calTotalPage(int pageSize) {
        if (totalCount < 0) {
            return 0;
        }
        if((totalCount + 1) / pageSize>0){
            return (totalCount + 1) / pageSize;
        }
        return 1;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public int getTotalPage() {
        return totalPage;
    }

    public int getPageSize() {
        return pageSize;
    }

    public int getOffset() {
        return offset;
    }

    public int getMax() {
        return max;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setMax(int max) {
        this.max = max;
    }
}
