package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/3/12.
 */
@Getter
public enum TuiaOrderStatusEnum {

    UNKNOWN(99, "unknown", "未知"),
    SEND_CODE_SUCCESS(1, "sendCodeSuccess", "发送短信成功"),
    SEND_CODE_FAIL(2, "sendCodeFail", "发送短信失败"),
    ORDER(3, "order", "已下单"),
    ORDER_SUCCESS(4, "order_success", "下单成功"),
    ORDER_FAIL(5, "orderFail", "下单失败");
    private final Integer code;
    private final String type;
    private final String desc;

    TuiaOrderStatusEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static TuiaOrderStatusEnum getByCode(Integer code) {
        return Stream.of(TuiaOrderStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNKNOWN);
    }

    public static TuiaOrderStatusEnum getByType(String type) {
        return Stream.of(TuiaOrderStatusEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNKNOWN);
    }
    public static TuiaOrderStatusEnum getByDesc(String desc) {
        return Stream.of(TuiaOrderStatusEnum.values()).filter(e -> e.getDesc().equals(desc)).findFirst().orElse(UNKNOWN);
    }

    public static Boolean includeByDesc(String desc){
        return Stream.of(TuiaOrderStatusEnum.values()).anyMatch(e -> e.getDesc().equals(desc));
    }
}
