package cn.com.duiba.tuia.subscribe.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.subscribe.api.dto.PageDto;
import cn.com.duiba.tuia.subscribe.api.dto.ProductDto;
import cn.com.duiba.tuia.subscribe.api.dto.ProductQueryParam;
import org.springframework.web.bind.annotation.*;


/**
 * <p>
 * 产品表 前端控制器
 * </p>
 *
 * @author hong
 * @since 2024/03/05
 */
@AdvancedFeignClient
public interface RemoteProductService{
    /**
     * 添加产品
     * @param req
     * @param result
     * @return
     */
    Boolean addProduct(ProductDto req) throws BizException;

    /**
     * 编辑产品
     * @param req
     * @param result
     * @return
     */
    Boolean editProduct(ProductDto req) throws BizException;

    /**
     * 查询产品详情
     * @param id
     * @return
     */
    ProductDto queryProductDetail(Long id) throws BizException;


    /**
     * 查询产品列表
     * @return
     */
   PageDto<ProductDto> listProduct(ProductQueryParam param);


    /**
     * 删除产品
     * @return
     */
    Boolean delProduct(Long id) throws BizException;
}
