package cn.com.duiba.tuia.subscribe.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.subscribe.api.dto.ClearPointsReq;
import cn.com.duiba.tuia.subscribe.api.dto.ClearPointsResult;
import cn.com.duiba.tuia.subscribe.api.dto.CreditsDto;
import cn.com.duiba.tuia.subscribe.api.dto.GrantPointsDto;
import cn.com.duiba.tuia.subscribe.api.dto.OrderRewardDto;
import cn.com.duiba.tuia.subscribe.api.dto.ProductPointsDto;

/**
 * Created by hong
 * time 2024/5/27.
 */
@AdvancedFeignClient
public interface RemoteUserEquityService {

    Boolean orderReward(OrderRewardDto dto);

    Boolean refund(String phone, Integer productCode, String aOid);

    CreditsDto queryCredits(String phone, Integer productCode, String aOid);

    // ========== 代扣业务新增方法 ==========

    /**
     * 发放积分（支持多笔、多产品、多过期时间）
     */
    Boolean grantPoints(GrantPointsDto dto);

    /**
     * 按产品清空积分（退款用）
     */
    ClearPointsResult clearPointsByProduct(ClearPointsReq req);

    /**
     * 按产品查询积分
     */
    ProductPointsDto queryPointsByProduct(ClearPointsReq req);
}
