/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.subscribe.api.enums;

import java.util.stream.Stream;

public enum TuiaOrderStatusEnum {
    UNKNOWN(99, "unknown", "\u672a\u77e5"),
    SEND_CODE_SUCCESS(1, "sendCodeSuccess", "\u53d1\u9001\u77ed\u4fe1\u6210\u529f"),
    SEND_CODE_FAIL(2, "sendCodeFail", "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25"),
    ORDER(3, "order", "\u5df2\u4e0b\u5355"),
    ORDER_SUCCESS(4, "order_success", "\u4e0b\u5355\u6210\u529f"),
    ORDER_FAIL(5, "orderFail", "\u4e0b\u5355\u5931\u8d25");

    private final Integer code;
    private final String type;
    private final String desc;

    private TuiaOrderStatusEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static TuiaOrderStatusEnum getByCode(Integer code) {
        return Stream.of(TuiaOrderStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNKNOWN);
    }

    public static TuiaOrderStatusEnum getByType(String type) {
        return Stream.of(TuiaOrderStatusEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNKNOWN);
    }

    public static TuiaOrderStatusEnum getByDesc(String desc) {
        return Stream.of(TuiaOrderStatusEnum.values()).filter(e -> e.getDesc().equals(desc)).findFirst().orElse(UNKNOWN);
    }

    public static Boolean includeByDesc(String desc) {
        return Stream.of(TuiaOrderStatusEnum.values()).anyMatch(e -> e.getDesc().equals(desc));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }
}

