package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/1/2.
 */
@Getter
public enum OperatorProductEnum {

    YIPAY(1, "yiPay", "翼支付"),
    NANSHAN(2, "nanShan", "南山"),
    GUANGDIAN(3, "guangDian", "广电"),
    CHINAMOBILE(4, "chinamobile", "上海移动"),
    GOLDDIGGERS(5, "goldDiggers", "挖金客"),
    ZHONGLIAN(6, "ZHONGLIAN", "众联"),;

    private final Integer code;
    private final String type;
    private final String desc;

    OperatorProductEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static OperatorProductEnum getByCode(Integer code) {
        return Stream.of(OperatorProductEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(YIPAY);
    }

    public static OperatorProductEnum getByType(String type) {
        return Stream.of(OperatorProductEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(YIPAY);
    }

    public static Boolean includeByCode(Integer code){
        return Stream.of(OperatorProductEnum.values()).anyMatch(e -> e.getCode().equals(code));
    }
}
