package cn.tuia.tuia.treasure.center.api.dto;


import java.io.Serializable;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by zhou_wb on 2018/5/6.
 */
public class ArticleDto implements Serializable {

    /**
     * 文章Id
     */
    private Long id;

    /**
     * 文章缩略图
     */
    private String  headImgUrl;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 文章标题
     */
    private String title;

    /**
     * 文章摘要
     */
    private String articleAbstract;

    /**
     * 账号
     */
    private Long accountId;

    /**
     * 文章标签
     */
    private String tags;

    /**
     * 文章url
     */
    private String url;


    /**
     * 文章状态
     */
    private Integer articleStatus;


    /**
     * 文章来源
     */
    private Integer articleSource;

    /**
     * 是否置顶
     */
    private Integer isStick;

    /**
     * 下线原因
     */
    private String offLineReason;

    /**
     * 下线时间
     */
    private Date gmtOffLine;


    /**
     * 发布时间
     */
    private Date gmtPublish;

    /**
     * 入库当前时间
     */
    private Date curDate;


    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 标签内容
     */
    private List<String> tagsContent;
    /**
     * 第三方文章关联id
     */
    private String thirdArticleId;
    /**
     * 第三方作者关联id
     */
    private String thirdAccountId;

    /**
     * 文章风险等级 pass：通过 block:高危 review：低危 pending:待审核
     */
    private Integer suggestion;

    /**
     * 文章风险等级 pass：通过 block:高危 review：低危 pending:待审核
     */
    private List<ScenesDto> scenesVoList;

    /**
     * 三图准备
     */
    private List<String> otherImgList;

    /**
     * 文章来源（新）
     */
    private String originSource;

    public String getOriginSource() {
        return originSource;
    }

    public void setOriginSource(String originSource) {
        this.originSource = originSource;
    }

    public String getThirdAccountId() {
        return thirdAccountId;
    }

    public void setThirdAccountId(String thirdAccountId) {
        this.thirdAccountId = thirdAccountId;
    }

    public String getThirdArticleId() {
        return thirdArticleId;
    }

    public void setThirdArticleId(String thirdArticleId) {
        this.thirdArticleId = thirdArticleId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getHeadImgUrl() {
        return headImgUrl;
    }

    public void setHeadImgUrl(String headImgUrl) {
        this.headImgUrl = headImgUrl;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getArticleAbstract() {
        return articleAbstract;
    }

    public void setArticleAbstract(String articleAbstract) {
        this.articleAbstract = articleAbstract;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getArticleStatus() {
        return articleStatus;
    }

    public void setArticleStatus(Integer articleStatus) {
        this.articleStatus = articleStatus;
    }

    public Integer getArticleSource() {
        return articleSource;
    }

    public void setArticleSource(Integer articleSource) {
        this.articleSource = articleSource;
    }

    public Integer getIsStick() {
        return isStick;
    }

    public void setIsStick(Integer isStick) {
        this.isStick = isStick;
    }

    public String getOffLineReason() {
        return offLineReason;
    }

    public void setOffLineReason(String offLineReason) {
        this.offLineReason = offLineReason;
    }

    public Date getGmtOffLine() {
        return gmtOffLine;
    }

    public void setGmtOffLine(Date gmtOffLine) {
        this.gmtOffLine = gmtOffLine;
    }

    public Date getGmtPublish() {
        return gmtPublish;
    }

    public void setGmtPublish(Date gmtPublish) {
        this.gmtPublish = gmtPublish;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public List<String> getTagsContent() {
        return tagsContent;
    }

    public void setTagsContent(List<String> tagsContent) {
        this.tagsContent = tagsContent;
    }

    public Integer getSuggestion() {
        return suggestion;
    }

    public void setSuggestion(Integer suggestion) {
        this.suggestion = suggestion;
    }

    public List<ScenesDto> getScenesVoList() {
        return scenesVoList;
    }

    public void setScenesVoList(List<ScenesDto> scenesVoList) {
        this.scenesVoList = scenesVoList;
    }

    public List<String> getOtherImgList() {
        return otherImgList;
    }

    public void setOtherImgList(List<String> otherImgList) {
        this.otherImgList = otherImgList;
    }
}
