package cn.tuia.tuia.treasure.center.api.enums;

import java.util.List;

/**
 * Created by xuefeng on 2018/12/19.
 */
public enum SlotPositionConfig {

    /**
     * 广点通三图
     */
    GDT_THREE(0),

    /**
     * 广点通小图
     */
    GDT_SMALL(1),

    /**
     * 广点通大图
     */
    GDT_BIG(2),

    /**
     * 广点通顶部横幅
     */
    GDT_TOP_BANNER(3),

    /**
     * 广点通底部横幅
     */
    GDT_DOWN_BANNER(4),

    /**
     * 百度大图
     */
    BAIDU_BIG(5),

    /**
     * 百度小图
     */
    BAIDU_SMALL(6),

    /**
     * 推啊互动
     */
    TUIA_INTERACT(7),

    /**
     * 推啊大图
     */
    TUIA_BIG(8),

    /**
     * 推啊小图
     */
    TUIA_SMALL(9);

    private Integer type;

    SlotPositionConfig(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    //三图模式
    public Boolean isThree() {
        return this.equals(GDT_THREE);
    }

    //广点通
    public Boolean isGdt() {
        return this.equals(GDT_THREE) || this.equals(GDT_BIG) || this.equals(GDT_SMALL) || this.equals(GDT_TOP_BANNER) || this.equals(GDT_DOWN_BANNER);
    }

    //百度
    public Boolean isBaidu() {
        return this.equals(BAIDU_BIG) || this.equals(BAIDU_SMALL);
    }

    //推啊直投
    public Boolean isTuiaDirect() {
        return this.equals(TUIA_BIG) || this.equals(TUIA_SMALL);
    }

    //大图
    public Boolean isBig() {
        return this.equals(GDT_BIG) || this.equals(BAIDU_BIG) || this.equals(TUIA_BIG);
    }

    //小图
    public Boolean isSmall() {
        return this.equals(GDT_SMALL) || this.equals(BAIDU_SMALL) || this.equals(TUIA_SMALL);
    }
}
