package cn.tuia.tuia.treasure.center.api.dto;


import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by zhou_wb on 2018/4/23.
 */
public class StickContentDto implements Serializable{


    private static final long serialVersionUID = 1260424276929123087L;

    /**
     * id
     */
    private Long id;
    /**
     * 内容标题
     */
    private  String title;


    /**
     * 内容链接地址
     */
    private String url;


    /**
     * 缩略图地址
     */
    private String  imageUrl;

    /**
     * 内容排序
     */
    private Integer sort;


    /**
     * 媒体名称
     */
    private String mediaName;

    /**
     * 评论数
     */
    private Long commentNumber;

    /**
     * 发布日期
     * @return
     */
    private Date gmtCreate;

    /**
     * 是否已删除
     * @return
     */
    private Integer isDelete;

    /**
     *文章id
     * @return
     */
    private Long foodId;

    /**
     * 文章作者id
     * @return
     */
    private Long accountId;

    /**
     * 文章来源
     * @return
     */
    private Integer articleSource;

    private String originSource;

    /**
     * 多图模式图片链接
     */
    private String otherImg;
    /**
     * 入库时间
     */
    private Date createTime;


    public List<String> getOtherImgs(){
        try {
            JSONObject jsonObject = JSONObject.parseObject(otherImg);
            if (null != jsonObject){
                return jsonObject.entrySet().stream().sorted(Map.Entry.comparingByKey()
                ).map(Map.Entry::getValue).map(Object::toString).collect(Collectors.toList());
            }

        }catch (Exception e){
            return Collections.emptyList();
        }

        return Collections.emptyList();
    }

    public String getOriginSource() {
        return originSource;
    }

    public void setOriginSource(String originSource) {
        this.originSource = originSource;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getArticleSource() {
        return articleSource;
    }

    public void setArticleSource(Integer articleSource) {
        this.articleSource = articleSource;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getMediaName() {
        return mediaName;
    }

    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCommentNumber() {
        return commentNumber;
    }

    public void setCommentNumber(Long commentNumber) {
        this.commentNumber = commentNumber;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Long getFoodId() {
        return foodId;
    }

    public void setFoodId(Long foodId) {
        this.foodId = foodId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getOtherImg() {
        return otherImg;
    }

    public void setOtherImg(String otherImg) {
        this.otherImg = otherImg;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
