package cn.tuia.tuia.treasure.center.api.enums;

import java.util.Objects;

public enum MeiPaiCategoryEnum {

    MUSIC("1001", "音乐"),
    DANCE("1039", "舞蹈"),
    PERFORMANCE("1084", "表演"),
    TALENT("1085", "才艺"),
    SELFIE("1089", "自拍"),
    PET("1090", "宠物"),
    FOOD("1092", "美食"),
    EAT_SHOW("1093", "吃秀"),
    NEWS("1101", "新闻"),
    OTHER("1103", "其他"),
    CREATIVE("1100", "创意"),
    UP_POSTURE("1097", "涨姿势"),

    ;
    private String code;
    private String desc;

    MeiPaiCategoryEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getCodeByDesc(String desc) {
        for (MeiPaiCategoryEnum value : MeiPaiCategoryEnum.values()) {
            if (Objects.equals(value.getDesc(), desc)) {
                return value.getCode();
            } else if (Objects.equals("新闻资讯", desc)) {
                return NEWS.getCode();
            }
        }
        return UP_POSTURE.getCode();
    }

    /**
     * 获取埋点中的描述
     *
     * @param desc
     * @return
     */
    public static String getChannelDesc(String desc) {
        for (MeiPaiCategoryEnum value : MeiPaiCategoryEnum.values()) {
            if (Objects.equals(value.getDesc(), desc)) {
                return value.getCode() + value.getDesc();
            }
        }
        return null;
    }
}
