package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.ArticleContentDto;
import cn.tuia.tuia.treasure.center.api.dto.ArticleDto;
import cn.tuia.tuia.treasure.center.api.dto.ArticleEditAbleDto;
import cn.tuia.tuia.treasure.center.api.dto.ArticleQueryDto;
import cn.tuia.tuia.treasure.center.api.dto.ArticleStatusDto;
import cn.tuia.tuia.treasure.center.api.dto.ArticleStickStatusDto;
import cn.tuia.tuia.treasure.center.api.dto.ArticleThirdDto;
import cn.tuia.tuia.treasure.center.api.dto.ExpectDto;
import cn.tuia.tuia.treasure.center.api.dto.PageQueryResultDto;
import cn.tuia.tuia.treasure.center.api.dto.SlotAccountMappingDto;
import cn.tuia.tuia.treasure.center.api.dto.TagArticleNumDto;
import cn.tuia.tuia.treasure.center.api.dto.articleopt.ArticleDetailDto;
import cn.tuia.tuia.treasure.center.api.dto.articleopt.ArticleNumDto;
import cn.tuia.tuia.treasure.center.api.dto.articleopt.ArticleNumReqDto;
import cn.tuia.tuia.treasure.center.api.dto.articleopt.ArticleNumResultQueryDto;
import cn.tuia.tuia.treasure.center.api.dto.articleopt.ArticleOptDto;
import cn.tuia.tuia.treasure.center.api.dto.articletagnum.ArticleTagNumDto;
import cn.tuia.tuia.treasure.center.api.dto.articletagnum.ArticleTagNumReqDto;

import java.util.List;

/**
 * Created by zhou_wb on 2018/4/23.
 */
@AdvancedFeignClient
public interface RemoteArticleNumService {
    /**
     * 插入操作信息
     */
    void insert(ArticleOptDto articleOptDto);


    /**
     * 获取运营们操作文章数
     */
    ArticleNumResultQueryDto query(ArticleNumReqDto articleNumReqDto);


    /**
     * 当前运营当天操作文章数
     */
    ArticleNumDto queryByAccount(ArticleDetailDto articleDetailDto);


    /**
     * 标签下文章数量
     */
    List<ArticleTagNumDto> queryTagNum(ArticleTagNumReqDto articleTagNumReqDto);


    /**
     * 获取运用操作文章详情
     */
    PageQueryResultDto<ArticleDto> queryDetail(ArticleDetailDto articleDetailDto);
}
