package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.SlotPositionDto;
import cn.tuia.tuia.treasure.center.api.dto.SlotPositionPercentDto;

import java.util.List;

/**
 * Created by xuefeng on 2018/12/20.
 */
@AdvancedFeignClient
public interface RemoteSlotPositionService {

    /**
     * 查询广告位置列表随机配置
     * @param stable
     * @param articleSource
     * @return
     */
    List<SlotPositionDto> queryRandomSlotPositions(Boolean stable, Integer articleSource);

    /**
     * 查询广告位置列表
     * @return
     */
    List<SlotPositionDto> querySlotPositions(Boolean stable);

    /**
     * 查询广告位置-配置百分比
     * @param slotPositionId
     * @return
     */
    List<SlotPositionPercentDto> querySlotPositionPercent(Long slotPositionId);

    /**
     * 更新广告位置(启用/停用)
     * @return
     */
    Boolean updateOpen(SlotPositionDto slotPositionDto);

    /**
     * 更新广告位置-百分比配置
     * @param list
     * @return
     */
    Boolean updatePercent(List<SlotPositionPercentDto> list);

    /**
     * 删除广告位置-百分比配置
     * @param slotPositionId
     * @param percentGroup
     * @return
     */
    Boolean deletePercentGroup(Long slotPositionId, Integer percentGroup);
}
