package cn.tuia.tuia.treasure.center.api.enums;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Create by yuanwei
 * at 2019/1/8 0008 下午 15:41
 */
public enum HotArticleSource {
    WXB(1,"微小宝","img","data-src",1751L,5),
    NEWRANK(2,"新榜","img","data-croporisrc",1751L,9),
    TOUTIAO(3,"今日头条","img","src",1751L,7),
    FENGHUANG(4,"凤凰新闻","img","src",1751L,6),
    WANGYI(5,"网易新闻","img","src",1751L,8);

    private Integer code;
    private String name;
    private String firstReg;
    private String secondReg;
    private Long accountId;
    private Integer articleSource;

    HotArticleSource(Integer code, String name, String firstReg, String secondReg ,Long accountId,Integer articleSource) {
        this.code = code;
        this.name = name;
        this.firstReg = firstReg;
        this.secondReg = secondReg;
        this.accountId = accountId;
        this.articleSource = articleSource;
    }

    private static Map<String, HotArticleSource> cache = Stream.of(HotArticleSource.values()).collect(Collectors.toMap(a -> a.name().toUpperCase(), a -> a));

    public static HotArticleSource getByCode(String code){
        return cache.get(code.toUpperCase());
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstReg() {
        return firstReg;
    }

    public void setFirstReg(String firstReg) {
        this.firstReg = firstReg;
    }

    public String getSecondReg() {
        return secondReg;
    }

    public void setSecondReg(String secondReg) {
        this.secondReg = secondReg;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Integer getArticleSource() {
        return articleSource;
    }

    public void setArticleSource(Integer articleSource) {
        this.articleSource = articleSource;
    }
}
