package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.PageQueryResultDto;
import cn.tuia.tuia.treasure.center.api.dto.VideoDto;
import cn.tuia.tuia.treasure.center.api.dto.req.RecommendVideoReq;
import cn.tuia.tuia.treasure.center.api.dto.req.VideoListQueryReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteVideoService {

    /**
     * @return 视频详表
     */
    List<VideoDto> getRecommendVideo(RecommendVideoReq req);


    /**
     * 视频点赞
     * @param id 视频id
     * @return
     */
    Boolean updateLikesCount(Long userId,Long id);

    /**
     * 获取视频详情
     * @param videoId 视频id
     * @return 视频详情
     */
    VideoDto getVideoDetail(Long videoId);

    /**
     * 随机获取视频列表
     * @return 视频详情
     */
    List<VideoDto> getRandomVideoList(Integer count);

    /**
     * 管理端查询视频列表
     * @return 视频详情
     */
    PageQueryResultDto<VideoDto> getVideoList(VideoListQueryReq req);

    /**
     * 新增视频
     * @param dto
     * @return
     */
    int addVideo(VideoDto dto);

    /**
     * 下架视频
     * @param id 视频id
     * @return
     */
    int offVideo(Long id);


    int update(VideoDto dto);

}
