package cn.tuia.tuia.treasure.center.api.dto;

import com.alibaba.fastjson.JSONObject;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by zhou_wb on 2018/4/23.
 */
public class ArticleContentDto implements Serializable {


    private static final long serialVersionUID = -60903987601298769L;
    /**
     * id
     */
    private Long id;
    /**
     * 内容标题
     */
    private  String title;


    /**
     * 内容链接地址
     */
    private String url;


    /**
     * 缩略图地址
     */
    private String  headImgUrl;

    /**
     * 文章作者Id
     */
    private Long accountId;

    /** 当前文章所在的标签 */
    private String tags;

    /**
     * 评论数
     */
    private Long commentNumber;

    /**
     * 发布日期
     * @return
     */
    private Date gmtPublish;
    /**
     * 文章来源
     */
    private Integer articleSource;


    private String otherImg;

    /**
     * 文章来源（新）
     */
    private String originSource;
    /**
     * 入库时间
     */
    private Date gmtCreate;

    /** 是否是人工推荐文章 */
    private Integer isRecommend;

    /** 用于阿里云推荐-点击，曝光埋点回传 **/
    private String traceInfo;

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getOriginSource() {
        return originSource;
    }

    public void setOriginSource(String originSource) {
        this.originSource = originSource;
    }

    public List<String> getOtherImgs(){
        try {
            JSONObject jsonObject = JSONObject.parseObject(otherImg);
            if (null != jsonObject){
                List<String> imgList = jsonObject.entrySet().stream().sorted(Map.Entry.comparingByKey()
                ).map(Map.Entry::getValue).map(Object::toString).collect(Collectors.toList());
                return imgList;
            }

        }catch (Exception e){
            return Collections.emptyList();
        }

        return Collections.emptyList();
    }



    public Integer getArticleSource() {
        return articleSource;
    }

    public void setArticleSource(Integer articleSource) {
        this.articleSource = articleSource;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHeadImgUrl() {
        return headImgUrl;
    }

    public void setHeadImgUrl(String headImgUrl) {
        this.headImgUrl = headImgUrl;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getCommentNumber() {
        return commentNumber;
    }

    public void setCommentNumber(Long commentNumber) {
        this.commentNumber = commentNumber;
    }

    public Date getGmtPublish() {
        return gmtPublish;
    }

    public void setGmtPublish(Date gmtPublish) {
        this.gmtPublish = gmtPublish;
    }

    public String getOtherImg() {
        return otherImg;
    }

    public void setOtherImg(String otherImg) {
        this.otherImg = otherImg;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }

    public String getTraceInfo() {
        return traceInfo;
    }

    public void setTraceInfo(String traceInfo) {
        this.traceInfo = traceInfo;
    }
}
