package cn.tuia.tuia.treasure.center.api.dto.recommend;

import com.google.common.collect.Sets;

import java.io.Serializable;
import java.util.Set;

/**
 * 用户推荐方式分流配置
 * 新老用户可以用一个
 * @author lichao 2019/1/15
 */
public class UserSplitDto implements Serializable {

    private Set<Integer> ali;//阿里云推荐

    private Set<Integer>  handred;//百优文章

    private Set<Integer>  newRecomend;//新用户推荐

    private Set<Integer>  dayRecommend;//日常推荐

    private Set<Integer>  individuation;//关键字算法

    //剩下的为旧算法
    public Set<Integer> getOld(){
        Set<Integer> set = Sets.newHashSet();
        if(ali!=null) {
            set.addAll(ali);
        }
        if(handred!=null) {
            set.addAll(handred);
        }
        if(newRecomend!=null) {
            set.addAll(newRecomend);
        }
        if(dayRecommend!=null) {
            set.addAll(dayRecommend);
        }
        if(individuation!=null){
            set.addAll(individuation);
        }
        Set<Integer> all = Sets.newHashSet(0,1,2,3,4,5,6,7,8,9);
        all.removeAll(set);
        return all;
    }

    public Set<Integer> getAli() {
        return ali;
    }

    public void setAli(Set<Integer> ali) {
        this.ali = ali;
    }

    public Set<Integer> getHandred() {
        return handred;
    }

    public void setHandred(Set<Integer> handred) {
        this.handred = handred;
    }

    public Set<Integer> getNewRecomend() {
        return newRecomend;
    }

    public void setNewRecomend(Set<Integer> newRecomend) {
        this.newRecomend = newRecomend;
    }

    public Set<Integer> getDayRecommend() {
        return dayRecommend;
    }

    public void setDayRecommend(Set<Integer> dayRecommend) {
        this.dayRecommend = dayRecommend;
    }

    public Set<Integer> getIndividuation() {
        return individuation;
    }

    public void setIndividuation(Set<Integer> individuation) {
        this.individuation = individuation;
    }
}
