/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tuia.treasure.center.api.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum ArticleSource {
    WECHAT(1, "\u5fae\u4fe1\u516c\u4f17\u53f7"),
    WQQS(2, "\u7ef4\u6743\u9a91\u58eb"),
    WULI(3, "WuLi\u5934\u6761"),
    NTES(4, "\u7f51\u6613\u6709\u6599"),
    WCHA(5, "\u5fae\u4fe1\u70ed\u6587"),
    IFENG(6, "\u51e4\u51f0\u70ed\u6587"),
    TOUTIAO(7, "\u4eca\u65e5\u5934\u6761"),
    WANGYI(8, "\u7f51\u6613\u70ed\u6587"),
    NRANK(9, "\u65b0\u699c\u70ed\u6587"),
    QUTOUTIAO(10, "\u8da3\u5934\u6761");

    private Integer code;
    private String desc;
    private static final Map<Integer, ArticleSource> CACHE;

    private ArticleSource(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static ArticleSource of(Integer code) {
        return CACHE.get(code);
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ArticleSource.values()), ArticleSource::getCode);
    }
}

