package cn.com.duiba.tuia.videoidea.manager.model.exceptions;

import lombok.Getter;

import java.text.MessageFormat;

/**
 * @author lizhiheng
 */
@Getter
public class BizException extends RuntimeException {
    private final Error error;
    private final String message;

    public BizException(Error error) {
        super(error.getMessage());
        this.error = error;
        this.message = error.getMessage();
    }

    public BizException(Error error, Object... objects) {
        super(error.getMessage());
        this.error = error;
        this.message = MessageFormat.format(error.getMessage(), objects);
    }
}
