package cn.com.duiba.tuia.videoidea.manager.model.result;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author lizhiheng
 */
@Data
@NoArgsConstructor
public class ResultPage<T> {
    /**
     * 当前页面
     */
    private Long currentPage;
    /**
     * 总页数
     */
    private Long totalPage;
    /**
     * 分页查询count总数.
     */
    private Long totalCount;
    /**
     * 分页查询结果集.
     */
    private List<T> list;

    public ResultPage(Long totalCount, List<T> list) {
        this.totalCount = totalCount;
        this.list = list;
    }

    public ResultPage(Long currentPage, Long totalPage, Long totalCount, List<T> list) {
        this.currentPage = currentPage;
        this.totalPage = totalPage;
        this.totalCount = totalCount;
        this.list = list;
    }
}
