package cn.com.duiba.tuia.videoidea.manager.model.result;


import cn.com.duiba.tuia.videoidea.manager.model.enums.ErrorCode;

import java.util.List;

/**
 * @author cuiwx
 * @version 1.0 2022/2/28
 * @description <p>构造返回结果工具类 .
 */
public class ResultUtil {

    /**
     * 构造一个失败的返回结果.
     *
     * @param <T>  the generic type
     * @param code 错误码枚举
     * @return the error result do
     */
    public static <T> Result<T> fail(ErrorCode code) {
        Result<T> result = new Result<>();
        result.setCode(code.getCode());
        result.setDesc(code.getMessage());
        return result;
    }

    public static <T> ResultList<T> failList(ErrorCode code) {
        ResultList<T> result = new ResultList<>();
        result.setCode(code.getCode());
        result.setDesc(code.getMessage());
        result.setData(null);
        return result;
    }

    public static <T> Result<T> fail(String resultCode, String resultMessage) {
        Result<T> result = new Result<>();
        result.setCode(resultCode);
        result.setDesc(resultMessage);
        return result;
    }

    public static <T> Result<T> fail(String resultCode, String resultMessage, T t) {
        Result<T> result = new Result<>();
        result.setCode(resultCode);
        result.setDesc(resultMessage);
        result.setData(t);
        return result;
    }

    /**
     * <一句话功能描述>
     *
     * @param t
     * @return
     */
    public static <T> Result<T> success(T t) {
        Result<T> result = new Result<>();
        result.setCode(ErrorCode.E0000000.getCode());
        result.setDesc(ErrorCode.E0000000.getMessage());
        result.setData(t);
        return result;
    }

    public static <T> ResultList<T> success(List<T> t) {
        ResultList<T> result = new ResultList<>();
        result.setCode(ErrorCode.E0000000.getCode());
        result.setDesc(ErrorCode.E0000000.getMessage());
        result.setData(t);
        return result;
    }
}
