package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *  直投页区块的dto
 *  @author lichao 2018/6/11
 */
public class YoutuiGuidePageBlockDto {

    private Long id;

    /** 直投页id */
    private Long pageId;

    /** 区域名称 */
    private String regionName;

    /** 区域类型 */
    private Integer regionType;

    /** 区块名称 */
    private String blockName;

    /** 区块类型 */
    private Integer blockType;

    /** 广告id */
    private String advertId;

    /** 直投链接 */
    private String url;

    /** 图片 */
    private String image;

    private Date gmtCreate;

    private Date gmtModified;

    /** 活动id或直投页id */
    private String relationId;

    /** id 类型 */
    private Integer idType;


    private String extInfo;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Integer getRegionType() {
        return regionType;
    }

    public void setRegionType(Integer regionType) {
        this.regionType = regionType;
    }

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public Integer getBlockType() {
        return blockType;
    }

    public void setBlockType(Integer blockType) {
        this.blockType = blockType;
    }

    public String getAdvertId() {
        return advertId;
    }

    public void setAdvertId(String advertId) {
        this.advertId = advertId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public Integer getIdType() {
        return idType;
    }

    public void setIdType(Integer idType) {
        this.idType = idType;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public List<Long> getListAdvertIds() {
        List<Long> list = new ArrayList<>();
        if (StringUtils.isBlank(advertId)) {
            return list;
        }
        String[] array = advertId.split(",");

        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    public List<Long> getListRelationIds() {
        List<Long> list = new ArrayList<>();
        if (StringUtils.isBlank(relationId)) {
            return list;
        }
        String[] array = relationId.split(",");

        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }
}
