/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionRecordDto;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public enum MissionTimeType {
    DAY(0, "\u5929"){

        @Override
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto) {
            Calendar cal = this.getNowCalendar();
            Date startTime = cal.getTime();
            cal.add(5, 1);
            Date endTime = cal.getTime();
            recordDto.setGmtCreate(startTime);
            recordDto.setEndCreate(endTime);
            return recordDto;
        }
    }
    ,
    WEEK(1, "\u5468"){

        @Override
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto) {
            Calendar cal = this.getNowCalendar();
            cal.set(7, 1);
            Date startTime = cal.getTime();
            cal.add(5, 8);
            Date endTime = cal.getTime();
            recordDto.setGmtCreate(startTime);
            recordDto.setEndCreate(endTime);
            return recordDto;
        }
    }
    ,
    EVER(2, "\u6c38\u4e45"){

        @Override
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto) {
            return recordDto;
        }
    }
    ,
    TWODAY(3, "\u81ea\u5b9a\u4e49\u5929"){

        @Override
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto) {
            return recordDto;
        }
    };

    private Integer type;
    private String name;

    private MissionTimeType(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static MissionRecordDto getQuery(MissionDto dto) {
        for (MissionTimeType type : MissionTimeType.values()) {
            if (!Objects.equals(type.getType(), dto.getTimeType())) continue;
            MissionRecordDto recordDto = new MissionRecordDto();
            recordDto.setMissionId(dto.getId());
            return type.getTimeQuery(recordDto);
        }
        return null;
    }

    public abstract MissionRecordDto getTimeQuery(MissionRecordDto var1);

    protected Calendar getNowCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

