package cn.com.duiba.tuia.youtui.center.api.dto.rsp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 友推任务列表的响应
 * @author lichao 2018/6/28
 */
@ApiModel
public class MissionRsp implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务详情描述")
    private String desc;

    @ApiModelProperty("任务获得金钱")
    private Long amount;

    @ApiModelProperty("任务金钱的类型:0人民币 1金币")
    private Integer amountType;

    @ApiModelProperty("是否完成 0未完成，1完成")
    private Integer isDone = 0;

    @ApiModelProperty("任务分组")
    private Integer missionGroup;

    @ApiModelProperty("是否需要进度条")
    private boolean needProgress;

    @ApiModelProperty("进度条总量")
    private Integer progressNum;

    @ApiModelProperty("完成的进度数")
    private Integer progressDoneNum;

    @ApiModelProperty("任务的图标")
    private String missionIcon;

    //以下为通知的特殊字段
    @ApiModelProperty("通知栏图片")
    private String image;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Integer getIsDone() {
        return isDone;
    }

    public void setIsDone(Integer isDone) {
        this.isDone = isDone;
    }

    public Integer getMissionGroup() {
        return missionGroup;
    }

    public void setMissionGroup(Integer missionGroup) {
        this.missionGroup = missionGroup;
    }

    public boolean isNeedProgress() {
        return needProgress;
    }

    public void setNeedProgress(boolean needProgress) {
        this.needProgress = needProgress;
    }

    public Integer getProgressNum() {
        return progressNum;
    }

    public void setProgressNum(Integer progressNum) {
        this.progressNum = progressNum;
    }

    public Integer getProgressDoneNum() {
        return progressDoneNum;
    }

    public void setProgressDoneNum(Integer progressDoneNum) {
        this.progressDoneNum = progressDoneNum;
    }

    public String getMissionIcon() {
        return missionIcon;
    }

    public void setMissionIcon(String missionIcon) {
        this.missionIcon = missionIcon;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getAmountType() {
        return amountType;
    }

    public void setAmountType(Integer amountType) {
        this.amountType = amountType;
    }
}
