package cn.com.duiba.tuia.youtui.center.api.dto.rsp;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.AppClientPutConfigDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.WechatPutConfigDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 1.3.0版本内容配置响应
 */
@ApiModel("1.3.0版本内容配置响应")
public class ContentConfigRsp implements Serializable {

    /** 推广计划id **/
    @ApiModelProperty( value = "推广计划ID",dataType = "Long")
    private Long cyapId;

    /** 分享次数 **/
    @ApiModelProperty(value = "分享次数(PV)",dataType = "Long")
    private Long shareTime;

    @ApiModelProperty(value = "分享者头像集合",dataType = "List<String>")
    private List<String> shareManImgs;

    /** 累计金额 **/
    @ApiModelProperty(value = "累积金额",dataType = "Long")
    private Long amount;

    /** 内容id **/
    @ApiModelProperty(value = "内容ID",dataType = "Long")
    private Long contentId;

    /** 内容类型 1.活动 **/
    @ApiModelProperty(value = "内容类型(1:活动；2:直投页；3:任务；4:游戏)",dataType = "Integer")
    private Integer contentType;

    /** 是否被置顶 **/
    @ApiModelProperty(value = "置顶时间戳（不置顶时为空）",dataType = "Long")
    private Long isTopSort;

    /** 分享人数(人) **/
    @ApiModelProperty(value = "分享人数(UV)",dataType = "Long")
    private Long shareManNum;

    /** 平均金额 **/
    @ApiModelProperty(value = "平均收益(分)",dataType = "Long")
    private Long avgAmount;

    /** 预览url **/
    @ApiModelProperty(value = "预览URL",dataType = "String")
    private String previewUrl;

    @ApiModelProperty(value = "分享接口URL",dataType = "String")
    private String shareUrl;

    @ApiModelProperty(value = "客户端内样式配置",dataType = "String")
    private AppClientPutConfigDto acpc;

    @ApiModelProperty(value = "微信分享样式配置",dataType = "String")
    private WechatPutConfigDto wechatPutConfigDto;

    @ApiModelProperty(value = "外部内容url",dataType = "String")
    private String contextUrl;

    public String getContextUrl() {
        return contextUrl;
    }

    public void setContextUrl(String contextUrl) {
        this.contextUrl = contextUrl;
    }

    public Long getCyapId() {
        return cyapId;
    }

    public void setCyapId(Long cyapId) {
        this.cyapId = cyapId;
    }

    public Long getShareTime() {
        return shareTime;
    }

    public void setShareTime(Long shareTime) {
        this.shareTime = shareTime;
    }

    public List<String> getShareManImgs() {
        return shareManImgs;
    }

    public void setShareManImgs(List<String> shareManImgs) {
        this.shareManImgs = shareManImgs;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public Long getIsTopSort() {
        return isTopSort;
    }

    public void setIsTopSort(Long isTopSort) {
        this.isTopSort = isTopSort;
    }

    public Long getShareManNum() {
        return shareManNum;
    }

    public void setShareManNum(Long shareManNum) {
        this.shareManNum = shareManNum;
    }

    public Long getAvgAmount() {
        return avgAmount;
    }

    public void setAvgAmount(Long avgAmount) {
        this.avgAmount = avgAmount;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public AppClientPutConfigDto getAcpc() {
        return acpc;
    }

    public void setAcpc(AppClientPutConfigDto acpc) {
        this.acpc = acpc;
    }

    public WechatPutConfigDto getWechatPutConfigDto() {
        return wechatPutConfigDto;
    }

    public void setWechatPutConfigDto(WechatPutConfigDto wechatPutConfigDto) {
        this.wechatPutConfigDto = wechatPutConfigDto;
    }

    public static int compareThis(ContentConfigRsp contentConfigRsp1, ContentConfigRsp contentConfigRsp2) {
        if(0 == contentConfigRsp1.getIsTopSort() && 0 == contentConfigRsp2.getIsTopSort()){
            if (contentConfigRsp1.getShareTime().intValue() == contentConfigRsp2.getShareTime().intValue()) {
                return contentConfigRsp2.getAmount().intValue() - contentConfigRsp1.getAmount().intValue();
            } else {
                return contentConfigRsp2.getShareTime().intValue() - contentConfigRsp1.getShareTime().intValue();
            }
        }else if(0 != contentConfigRsp1.getIsTopSort() && 0 != contentConfigRsp2.getIsTopSort()){
            return contentConfigRsp2.getIsTopSort().intValue() - contentConfigRsp1.getIsTopSort().intValue();
        }else if(0 != contentConfigRsp1.getIsTopSort()){
            return -1;
        }else if(0 != contentConfigRsp2.getIsTopSort()){
            return 1;
        }
        return 0;
    }
}
