package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.rsp.OperationsPositionRsp;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiOperationsPositionDto;

import java.util.List;

/**
 * 运营位管理remote业务
 * @author liyuanzeng 2018/7/30
 */
@AdvancedFeignClient
public interface RemoteYoutuiOperationsPositionService {

    /**
     * 分页查询运营位表格数据
     * @param offset
     * @param max
     * @return
     */
    List<OperationsPositionRsp> selectList(Integer offset, Integer max);

    /**
     *  通过id查询运营位详情
     * @param id
     * @return
     */
    YoutuiOperationsPositionDto selectById(Long id);

    /**
     * 新增运营位信息
     * @param operationsPositionDto
     * @return
     */
    int insert(YoutuiOperationsPositionDto operationsPositionDto);

    /**
     * 修改运营位信息
     * @param operationsPositionDto
     * @return
     */
    int update(YoutuiOperationsPositionDto operationsPositionDto);

    /**
     * 通过id删除运营位信息
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 内容是否存在于运营位
     *
     * @param contextType
     * @param contextId
     * @return
     */
    Boolean isExsit(Integer contextType, Long contextId);

    /**
     * 根据内容类型 获取相应内容的ids
     * @param contextType
     * @return
     */
    List<Long> selectContentIdsByContentType(Integer contextType);

    /**
     * 通过关联id和关联类型查询运营位信息
     * @param relationId
     * @param relationType
     * @return
     */
    YoutuiOperationsPositionDto selectByRelationIdAndRelationType(Long relationId, Integer relationType);

    /**
     * 拖拉排序
     * @param startIndex
     * @param endIndex
     * @return
     */
    int updateSort(Integer startIndex, Integer endIndex);


    public List<YoutuiOperationsPositionDto> listAll();
}
