package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqCoinRate;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.CoinRateDto;

import java.util.Date;

/**
 * 有推金币与人民币转换remote业务
 * @author liyuanzeng 2018/8/2
 */
@AdvancedFeignClient
public interface RemoteCoinRateService {
    /**
     * 查询分页列表
     * @param req
     * @return
     */
    PageDto<CoinRateDto> queryPageList(ReqCoinRate req);


    /**
     * 新增
     * @param param
     * @return
     */
    Integer addCoinRate(CoinRateDto param);

    /**
     * 查询
     * @param curDate
     * @return
     */
    CoinRateDto queryCoinRate(Date curDate);

    /**
     * 修改
     * @param param
     * @return
     */
    Integer updateCoinRate(CoinRateDto param);

    /**
     * 查询日期最近的
     * @param curDate
     * @return
     */
    CoinRateDto queryRecentCoinRate(Date curDate);
}
