package cn.com.duiba.tuia.youtui.center.api.dto.rsp;

import java.io.Serializable;
import java.util.Date;


/**
 * Created by xuefeng on 2018/5/21.
 */
public class ContentStaticRsp implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 推广计划id **/
    private Long cyapId;

    /** 分享次数 **/
    private Long shareTime;

    /** 累计金额 **/
    private Long amount;

    /** 内容id **/
    private Long contentId;

    /** 内容类型 1.活动 **/
    private Integer contentType;

    /** title:活动标题. */
    private String title;

    /** app内展示的素材图片. */
    private String appMaterialImg;

    /** app内玩法说明图片. */
    private String appInstructionImg;

    /** 玩法说明 */
    private String instruction;

    /** 是否已分享 **/
    private Boolean isShared = false;

    /** 是否被置顶 **/
    private Long isTopSort;

    public Long getIsTopSort() {
        return isTopSort;
    }

    public void setIsTopSort(Long isTopSort) {
        this.isTopSort = isTopSort;
    }

    public Long getShareTime() {
        return shareTime;
    }

    public void setShareTime(Long shareTime) {
        this.shareTime = shareTime;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAppMaterialImg() {
        return appMaterialImg;
    }

    public void setAppMaterialImg(String appMaterialImg) {
        this.appMaterialImg = appMaterialImg;
    }

    public String getAppInstructionImg() {
        return appInstructionImg;
    }

    public void setAppInstructionImg(String appInstructionImg) {
        this.appInstructionImg = appInstructionImg;
    }

    public String getInstruction() {
        return instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public Boolean getShared() {
        return isShared;
    }

    public void setShared(Boolean shared) {
        isShared = shared;
    }

    public Long getCyapId() {
        return cyapId;
    }

    public void setCyapId(Long cyapId) {
        this.cyapId = cyapId;
    }

    public static int compareThis(ContentStaticRsp contentStaticRsp1, ContentStaticRsp contentStaticRsp2) {
        if(0 == contentStaticRsp1.getIsTopSort() && 0 == contentStaticRsp2.getIsTopSort()){
            if (contentStaticRsp1.getShareTime().intValue() == contentStaticRsp2.getShareTime().intValue()) {
                return contentStaticRsp2.getAmount().intValue() - contentStaticRsp1.getAmount().intValue();
            } else {
                return contentStaticRsp2.getShareTime().intValue() - contentStaticRsp1.getShareTime().intValue();
            }
        }else if(0 != contentStaticRsp1.getIsTopSort() && 0 != contentStaticRsp2.getIsTopSort()){
            return contentStaticRsp2.getIsTopSort().intValue() - contentStaticRsp1.getIsTopSort().intValue();
        }else if(0 != contentStaticRsp1.getIsTopSort()){
            return -1;
        }else if(0 != contentStaticRsp2.getIsTopSort()){
            return 1;
        }
        return 0;
    }
}
