package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionRecordDto;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * 友推的任务轮转类型
 * @author lichao 2018/6/29
 */
public enum MissionTimeType {

    DAY(0,"天"){
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto){
            Calendar cal = getNowCalendar();
            Date startTime = cal.getTime();
            cal.add(Calendar.DATE, 1);
            Date endTime = cal.getTime();
            recordDto.setGmtCreate(startTime);
            recordDto.setEndCreate(endTime);
            return recordDto;
        }
    },
    WEEK(1,"周"){
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto){
            Calendar cal = getNowCalendar();
            cal.set(Calendar.DAY_OF_WEEK,1);
            Date startTime = cal.getTime();
            cal.add(Calendar.DATE,8);
            Date endTime = cal.getTime();
            recordDto.setGmtCreate(startTime);
            recordDto.setEndCreate(endTime);
            return recordDto;
        }
    },
    EVER(2,"永久"){
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto){
            return recordDto;
        }

    },

    TWODAY(3,"自定义天"){//此类型有点特殊,是自定义的时间
        public MissionRecordDto getTimeQuery(MissionRecordDto recordDto){

            return recordDto;
        }
    }
    ;
    //任务轮转类型0天，1周,2永久，3.2天
    private Integer type;
    private String name;

    MissionTimeType(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static MissionRecordDto getQuery(MissionDto dto){
        for (MissionTimeType type : MissionTimeType.values()){
            if(Objects.equals(type.getType(),dto.getTimeType())){
                MissionRecordDto recordDto = new MissionRecordDto();
                recordDto.setMissionId(dto.getId());
                return type.getTimeQuery(recordDto);
            }
        }
        return null;
    }


    public abstract MissionRecordDto getTimeQuery(MissionRecordDto recordDto);

    protected Calendar getNowCalendar(){
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return cal;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
