/**
 * Project Name:activity-center-api<br>
 * File Name:ParseType.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.constant<br>
 * Date:2017年4月17日上午10:58:28<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.youtui.center.api.constant;

/**
 * ClassName: ParseType <br/>
 * Function: 解析类型. <br/>
 * Reason: 表示接口返回内容的解析类型. <br/>
 * date: 2017年4月17日 上午10:58:28 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public enum ParseType {
    /** JSON:json格式.*/
    JSON(1, "json"),
    /** FORM:form格式,例:name=value&name2=value2 .*/
    FORM(2,"form");

    private Integer type;

    /** desc:描述. */
    private String  desc;

    /**
     * Creates a new instance of ParseType.
     *
     * @param type
     * @param desc
     */

    ParseType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
