package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

/**
 * 内容类型
 * Created by xuefeng on 2018/5/18.
 */
public enum ContentType {

    Activity(1, "活动"),
    Direct(2,"直投页"),
    Mission(3,"任务"),
    Context(4,"外部内容"),
    Game(5,"游戏"),
    Airticle(6,"文章"),
    LandPage(7,"落地页"),
    ;

    private Integer type;
    private String content;

    ContentType(Integer type, String content) {
        this.type = type;
        this.content = content;
    }

    public Integer getType() {
        return type;
    }

    public String getContent() {
        return content;
    }

    public static ContentType getContentType(Integer code) {
        for (ContentType contentType : ContentType.values()) {
            if (code.equals(contentType.getType())) {
                return contentType;
            }
        }
        return null;
    }
}
