package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqGuidePageQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.rsp.RspGuidePage;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiGuidePageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiGuidePageSkinDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiSkinTemplateDto;

import java.util.List;

/**
 * 流量引导页后台管理
 * Create by yuanwei
 * at 2018/7/4 0004 下午 16:03
 */
@AdvancedFeignClient
public interface RemoteGuidePageManageService {

    /**
     * 查询流量引导页的表信息
     * @param req
     * @return
     */
    PageDto<RspGuidePage> queryGuidePageList(ReqGuidePageQuery req);

    /**
     * 通过id查询流量引导页信息
     * @param id
     * @return
     */
    RspGuidePage selectGuidepageDetailById(Long id);

    /**
     * 通过id查询流量引导页皮肤信息
     * @param id
     * @return
     */
    YoutuiGuidePageSkinDto selectGuidepageSkinDetailById(Long id);

    /**
     * 通过皮肤类型和分组查询流量引导页的皮肤信息
     * @param type
     * @param group
     * @return
     */
    List<YoutuiSkinTemplateDto> selectGuidepageSkinByType(Integer type, Integer group);

    /**
     * 保存流量引导页
     * @param dto
     * @return
     */
    Long saveGuidePage(YoutuiGuidePageDto dto);

    /**
     * 通过id逻辑删除流量引导页
     * @param id
     * @return
     */
    int deleteGuidePage(Long id);

    /**
     * 获取流量引导页的皮肤表格数据
     * @param offset
     * @param max
     * @return
     */
    PageDto<YoutuiGuidePageSkinDto> getGuidePageSkinList(Integer offset , Integer max);

    /**
     * 保存流量引导页皮肤
     * @param dto
     * @return
     */
    Long saveGuideSkin(YoutuiGuidePageSkinDto dto);


}
