package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import cn.com.duiba.tuia.youtui.center.api.util.RandomFlowUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * Create by yuanwei
 * at 2018/8/31 0031 上午 11:34
 */
@ApiModel("答题配置")
public class YoutuiBaseAnswerConfigDto implements Serializable {

    @ApiModelProperty(value = "答题内容配置",dataType = "List<questionConfig>")
    private List<QuestionConfig> questionConfigs;
    @ApiModelProperty(value = "答题结果配置")
    private List<AnswerResult> answerResults;
    @ApiModelProperty(value = "查看错题，0：不查看错题，2：查看错题",dataType = "Integer")
    private Integer isAgain;

    public List<QuestionConfig> getQuestionConfigs() {
        return questionConfigs;
    }

    public void setQuestionConfigs(List<QuestionConfig> questionConfigs) {
        this.questionConfigs = questionConfigs;
    }

    public List<AnswerResult> getAnswerResults() {
        return answerResults;
    }

    public void setAnswerResults(List<AnswerResult> answerResults) {
        this.answerResults = answerResults;
    }

    public Integer getIsAgain() {
        return isAgain;
    }

    public void setIsAgain(Integer isAgain) {
        this.isAgain = isAgain;
    }

    @ApiModel("题目配置")
    private static class QuestionConfig implements Serializable{

        @ApiModelProperty(value = "题目标题",dataType = "String")
        private String questionTitle;
        @ApiModelProperty(value = "题目图片url",dataType = "String")
        private String questionImgUrl;
        @ApiModelProperty(value = "正确答案",dataType = "String")
        private String correctKey;
        @ApiModelProperty(value = "题目描述",dataType = "String")
        private String questionDesc;
        @ApiModelProperty(value = "题目选项配置",dataType = "List<optionsConfig>")
        private List<OptionsConfig> options;

        public String getQuestionTitle() {
            return questionTitle;
        }

        public void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        public String getQuestionImgUrl() {
            return questionImgUrl;
        }

        public void setQuestionImgUrl(String questionImgUrl) {
            this.questionImgUrl = questionImgUrl;
        }

        public String getCorrectKey() {
            return correctKey;
        }

        public void setCorrectKey(String correctKey) {
            this.correctKey = correctKey;
        }

        public String getQuestionDesc() {
            return questionDesc;
        }

        public void setQuestionDesc(String questionDesc) {
            this.questionDesc = questionDesc;
        }

        public List<OptionsConfig> getOptions() {
            return options;
        }

        public void setOptions(List<OptionsConfig> options) {
            this.options = options;
        }

        @ApiModel("题目选项配置")
        private  static class OptionsConfig implements Serializable{
            @ApiModelProperty(value = "选项名",dataType = "String")
            private String optionName;
            @ApiModelProperty(value = "选项内容",dataType = "String")
            private String optionContent;
            @ApiModelProperty(value = "选项结果（测试题）",dataType = "String")
            private String optionResult;

            public String getOptionName() {
                return optionName;
            }

            public void setOptionName(String optionName) {
                this.optionName = optionName;
            }

            public String getOptionContent() {
                return optionContent;
            }

            public void setOptionContent(String optionContent) {
                this.optionContent = optionContent;
            }

            public String getOptionResult() {
                return optionResult;
            }

            public void setOptionResult(String optionResult) {
                this.optionResult = optionResult;
            }
        }
    }

    @ApiModel("答题结果配置")
    private static class AnswerResult extends BaseRatioDto implements Serializable   {
        @ApiModelProperty(value = "最终结果（测试题）",dataType = "String")
        private String finalResult;
        @ApiModelProperty(value = "最小值",dataType = "Integer")
        private Integer minNum;
        @ApiModelProperty(value = "最大值",dataType = "Integer")
        private Integer maxNum;
        @ApiModelProperty(value = "概率（随机测试题）",dataType = "Integer")
        private Integer rate;
        @ApiModelProperty(value = "结果",dataType = "String")
        private String result;
        @ApiModelProperty(value = "结果图片",dataType = "String")
        private String resultImgUrl;
        @ApiModelProperty(value = "链接主标题",dataType = "String")
        private String mainUrlTitle;
        @ApiModelProperty(value = "链接副标题",dataType = "String")
        private String subUrlTitle;
        @ApiModelProperty(value = "卡片图片",dataType = "String")
        private String cardImgUrl;

        public String getFinalResult() {
            return finalResult;
        }

        public void setFinalResult(String finalResult) {
            this.finalResult = finalResult;
        }

        public Integer getMinNum() {
            return minNum;
        }

        public void setMinNum(Integer minNum) {
            this.minNum = minNum;
        }

        public Integer getMaxNum() {
            return maxNum;
        }

        public void setMaxNum(Integer maxNum) {
            this.maxNum = maxNum;
        }

        public Integer getRate() {
            return rate;
        }

        public void setRate(Integer rate) {
            this.rate = rate;
        }

        public String getResult() {
            return result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getResultImgUrl() {
            return resultImgUrl;
        }

        public void setResultImgUrl(String resultImgUrl) {
            this.resultImgUrl = resultImgUrl;
        }

        public String getMainUrlTitle() {
            return mainUrlTitle;
        }

        public void setMainUrlTitle(String mainUrlTitle) {
            this.mainUrlTitle = mainUrlTitle;
        }

        public String getSubUrlTitle() {
            return subUrlTitle;
        }

        public void setSubUrlTitle(String subUrlTitle) {
            this.subUrlTitle = subUrlTitle;
        }

        public String getCardImgUrl() {
            return cardImgUrl;
        }

        public void setCardImgUrl(String cardImgUrl) {
            this.cardImgUrl = cardImgUrl;
        }
    }

    /**
     * 通过概率分流得到答题结果（随机测试题适用）
     * @return
     */
    public AnswerResult findAnswerResultByRato(){
        Integer index = RandomFlowUtil.computeIndex(this.answerResults);
        return this.answerResults.get(index);
    }

}
