package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.ContentStaticDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiContentReq;

import java.util.List;

/**
 * Created by xuefeng on 2018/7/28.
 */
@AdvancedFeignClient
public interface RemoteContentStaticService {

    /**
     * 根据所有内容维度统计数据
     * @return
     */
    List<ContentStaticDto> selectByContents(List<YoutuiContentReq> list);

    /**
     * 根据所有内容维度统计数据
     * @return
     */
    List<ContentStaticDto> selectAll();

    /**
     * 根据内容获取内容相关统计数据
     * @param contentReq
     * @return
     */
    ContentStaticDto selectByContent(YoutuiContentReq contentReq);

    /**
     * 临时用于 1。2-》2。0数据迁移
     * @param contentStaticDto
     */
    void update(ContentStaticDto contentStaticDto);
}
