package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import cn.com.duiba.tuia.youtui.center.api.constant.ErrorCode;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import cn.com.duiba.tuia.youtui.center.api.exception.YoutuiCenterException;
import cn.com.duiba.tuia.youtui.center.api.exception.YoutuiCenterRuntimeException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

@ApiModel("拼多多商品列表Dto")
public class PDDGoodsSearchDto extends BaseDto {

    @ApiModelProperty("商品总数")
    @JSONField(name="total_count")
    private String totalCount;

    @ApiModelProperty("商品列表")
    @JSONField(name="goods_list")
    private List<PDDGoodsDto> duoduojinbaoGoodsList;

    public String getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(String totalCount) {
        this.totalCount = totalCount;
    }

    public List<PDDGoodsDto> getDuoduojinbaoGoodsList() {
        return duoduojinbaoGoodsList;
    }

    public void setDuoduojinbaoGoodsList(List<PDDGoodsDto> duoduojinbaoGoodsList) {
        this.duoduojinbaoGoodsList = duoduojinbaoGoodsList;
    }


    @ApiModel("拼多多商品列表请求参数")
    public static class PDDGoodsSearchReq extends PDDBaseReq{

        @ApiModelProperty("商品关键词，与opt_id字段选填一个或全部填写")
        private String keyword;

        @ApiModelProperty("商品标签类目ID，使用pdd.goods.opt.get获取")
        private Integer opt_id;

        @ApiModelProperty("默认值1，商品分页数")
        private Integer page;

        @ApiModelProperty("默认100，每页商品数量")
        private Integer page_size;

        @ApiModelProperty("排序方式:0-综合排序;1-按佣金比率升序;2-按佣金比例降序;3-按价格升序;4-按价格降序;5-按销量升序;6-按销量降序;7-优惠券金额排序升序;8-优惠券金额排序降序;9-券后价升序排序;10-券后价降序排序;11-按照加入多多进宝时间升序;12-按照加入多多进宝时间降序;13-按佣金金额升序排序;14-按佣金金额降序排序;15-店铺描述评分升序;16-店铺描述评分降序;17-店铺物流评分升序;18-店铺物流评分降序;19-店铺服务评分升序;20-店铺服务评分降序;27-描述评分击败同类店铺百分比升序，28-描述评分击败同类店铺百分比降序，29-物流评分击败同类店铺百分比升序，30-物流评分击败同类店铺百分比降序，31-服务评分击败同类店铺百分比升序，32-服务评分击败同类店铺百分比降序")
        private Integer sort_type = 0;

        @ApiModelProperty("是否只返回优惠券的商品，false返回所有商品，true只返回有优惠券的商品")
        private Boolean with_coupon = true;

        @ApiModelProperty(value = "范围列表，可选值：[{\"range_id\":0,\"range_from\":1,\"range_to\":1500},{\"range_id\":1,\"range_from\":1,\"range_to\":1500}]",required = true)
        private List<PDDRangeParam> range_list;

        @ApiModelProperty("商品类目ID，使用pdd.goods.cats.get接口获取")
        private Integer cat_id;

        @ApiModelProperty(value = "商品ID列表。例如：[123456,123]，当入参带有goods_id_list字段，将不会以opt_id、 cat_id、keyword维度筛选商品",required = true)
        private List<Long> goods_id_list;

        @ApiModelProperty("招商多多客ID")
        private Integer zs_duo_id;

        @ApiModelProperty("店铺类型，1-个人，2-企业，3-旗舰店，4-专卖店，5-专营店，6-普通店（未传为全部）")
        private Integer merchant_type;

        public String getKeyword() {
            return keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        public Integer getOpt_id() {
            return opt_id;
        }

        public void setOpt_id(Integer opt_id) {
            this.opt_id = opt_id;
        }

        public Integer getPage() {
            return page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPage_size() {
            return page_size;
        }

        public void setPage_size(Integer page_size) {
            this.page_size = page_size;
        }

        public Integer getSort_type() {
            return sort_type;
        }

        public void setSort_type(Integer sort_type) {
            this.sort_type = sort_type;
        }

        public Boolean getWith_coupon() {
            return with_coupon;
        }

        public void setWith_coupon(Boolean with_coupon) {
            this.with_coupon = with_coupon;
        }

        public List<PDDRangeParam> getRange_list() {
            return range_list;
        }

        public void setRange_list(List<PDDRangeParam> range_list) {
            this.range_list = range_list;
        }

        public List<Long> getGoods_id_list() {
            return goods_id_list;
        }

        public void setGoods_id_list(List<Long> goods_id_list) {
            this.goods_id_list = goods_id_list;
        }

        public Integer getCat_id() {
            return cat_id;
        }

        public void setCat_id(Integer cat_id) {
            this.cat_id = cat_id;
        }

        public Integer getZs_duo_id() {
            return zs_duo_id;
        }

        public void setZs_duo_id(Integer zs_duo_id) {
            this.zs_duo_id = zs_duo_id;
        }

        public Integer getMerchant_type() {
            return merchant_type;
        }

        public void setMerchant_type(Integer merchant_type) {
            this.merchant_type = merchant_type;
        }

        @Override
        public String getType() {
            return "pdd.ddk.goods.search";
        }

        public PDDGoodsSearchReq() {
            this.sort_type = 0;
            this.with_coupon = true;
            this.opt_id = 0;
        }


        public PDDGoodsSearchReq(Integer sort_type, Boolean with_coupon,Integer opt_id) {
            this.sort_type = sort_type;
            this.with_coupon = with_coupon;
            this.opt_id = opt_id;
        }


        public static void main(String[] args) throws Exception {
            PDDGoodsSearchReq pddGoodsSearchReq = new PDDGoodsSearchReq();
            pddGoodsSearchReq.setPage_size(100);
            System.out.println(pddGoodsSearchReq.request().toJSONString());
        }

        /**
         * 请求
         * @return
         */
        public PDDGoodsSearchDto doRequest() throws Exception {
            JSONObject request = this.request();
            JSONObject goods_search_response = request.getJSONObject("goods_search_response");
            boolean empty = goods_search_response==null||goods_search_response.isEmpty();
            if(empty){
                //TODO 增加返回值
                throw new YoutuiCenterException(ErrorCode.E0000001);
            }
            return goods_search_response.toJavaObject(PDDGoodsSearchDto.class);
        }

        @Override
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("sort_type",this.getSort_type().toString());
            paramsMap.put("with_coupon",this.getWith_coupon().toString());
            if(StringUtils.isNotBlank(this.getKeyword())){
                paramsMap.put("keyword",this.getKeyword());
            }

            if(this.getOpt_id()!=null){
                paramsMap.put("opt_id",this.getOpt_id().toString());
            }

            if(this.getPage()!=null){
                paramsMap.put("page",this.getPage().toString());
            }

            if(this.getPage_size()!=null){
                paramsMap.put("page_size",this.getPage_size().toString());
            }

            if(!CollectionUtils.isEmpty(this.getRange_list())){
                paramsMap.put("range_list", JSON.toJSONString(this.getRange_list()));
            }

            if(this.getCat_id()!=null ){
                paramsMap.put("cat_id",this.getCat_id().toString());
            }

            if(!CollectionUtils.isEmpty(this.getGoods_id_list())){
                paramsMap.put("goods_id_list", JSON.toJSONString(this.getGoods_id_list()));
            }

            if(this.getZs_duo_id()!=null){
                paramsMap.put("zs_duo_id",this.getZs_duo_id().toString());
            }

            if(this.getMerchant_type()!=null){
                paramsMap.put("merchant_type",this.getMerchant_type().toString());
            }
            return paramsMap;
        }



    }
}
