package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 渠道
 * Created by xuefeng on 2018/6/5.
 */
public enum VersionChannel {
    TUIA(0,"tuia","内部使用版本"),
    YYSC_YYB(1, "yysc-yyb", "应用宝"),
    YYSC_HW(2, "yysc-hw", "华为"),
    YYSC_MZ(3, "yysc-mz", "魅族"),
    YYSC_OPPO(4, "yysc-oppo", "oppo"),
    YYSC_BD(5, "yysc-bd", "百度手机助手"),
    YYSC_XM(6, "yysc-xm", "小米"),
    YYSC_VIVO(7, "yysc-vivo", "vivo"),
    YYSC_360(8, "yysc-360", "360手机助手"),
    YYSC_ALI(9, "yysc-ali", "阿里"),
    YYSC_SG(10, "yysc-sg", "搜狗"),
    YYSC_RAW(11, "yysc-raw", "推啊"),
    YYSC_WECHAT1(12, "yysc-wechat1", "微信"),
    YYSC_WWCHAT2(13, "yysc-wechat2", "微信"),
    YYSC_RAW2(14, "yysc-raw2", "推啊2,推啊活动"),
    YYSC_RAW3(15, "yysc-raw3", "推啊3"),
    YYSC_RAW4(16, "yysc-raw4", "推啊4,用于友推第二版落地页"),
    YYSC_RAW5(17, "yysc-raw5", "推啊5,张敏落地页4"),
    YYSC_CC(18, "yysc-cc", "内容中心"),
    YYSC_RAW6(19, "yysc-raw6", "落地页链接待定"),
    YYSC_CHIJI(20, "yysc-chiji", "吃鸡"),
    YYSC_RAW7(21, "yysc-raw7", "趣晒推啊投放4"),
    YYSC_PYQA(22, "yysc-pyqa", "趣晒推啊投放4"),
    YYSC_PYQB(23, "yysc-pyqb", "趣晒推啊投放4"),
    YYSC_CC_ANSA(24, "yysc-cc-ansa", "答题王者 A-落地页"),
    YYSC_CC_ANSB(25, "yysc-cc-ansb", "答题王者 B-蒙层"),
    YYSC_CC_DRAWA(26, "yysc-cc-drawa", "你画我猜 A-落地页"),
    YYSC_CC_DRAWB(27, "yysc-cc-drawb", "你画我猜 B-蒙层"),
    YYSC_CC_FRIENDRA(28, "yysc-cc-friendra", "朋友圈热文红包 A-落地页"),
    YYSC_CC_FRIENDRB(29, "yysc-cc-friendrb", "朋友圈热文红包 B-蒙层"),
    YYSC_CC_WINTREASURE(30, "yysc-cc-wintreasure", "夺宝"),
    YYSC_CC_FOCUS(31, "yysc-cc-focus", "极限手速"),
    YYSC_RAW8(32, "yysc-raw8", "趣晒推啊投放6"),
    YYSC_CC_QIXIA(33, "yysc-cc-qixia", "七夕活动 A落地页"),
    YYSC_CC_QIXIB(34, "yysc-cc-qixib", "七夕活动 B蒙层"),
    YYSC_RAW9(35, "yysc-raw9", "趣闻banner"),
    YYSC_CC_A_YXGL_97_2(36, "yysc-cc-a-yxgl-97-2", "延禧攻略下载A 落地页"),
    YYSC_CC_B_YXGL_97_2(37, "yysc-cc-b-yxgl-97-2", "延禧攻略下载B 蒙层"),
    YYSC_XBRW_LOGO(38, "yysc-xbrw-logo", "新版热文logo下载"),
    YYSC_XBRW_TC(39, "yysc-xbrw-tc", "新版热文弹窗下载"),
    YYSC_RAW10(40, "yysc-raw10", "推啊投放10"),
    YYSC_A_H5COIN_102_2(41, "yysc-h5coin-a-102-2", "金币派送落地页"),
    YYSC_CC_A_FARM_2_5(42, "yysc-farm-a-2-5", "农场游戏"),
    YYSC_JIUYUE_LOGO(43,"yysc-jiuyue-logo","九月签logo下载"),
    YYSC_JIUYUE_WORD(44,"yysc-jiuyue-word","九月签更多测试下载"),
    YYSC_B_H5COIN_102_2(45, "yysc-h5coin-b-102-2", "金币派送二维码"),
    ;

    private Integer channel;

    private String channelString;

    private String name;

    VersionChannel(Integer channel, String channelString, String name) {
        this.channel = channel;
        this.channelString = channelString;
        this.name = name;
    }

    public Integer getChannel() {
        return channel;
    }

    public String getChannelString() {
        return channelString;
    }

    public String getName() {
        return name;
    }

    static final List<VersionChannel> cdkeys = Arrays.asList(YYSC_CC);

    public static Integer getByString(String channelString) {
        if (StringUtils.isBlank(channelString)) {
            return YYSC_RAW.getChannel();
        }
        for (VersionChannel versionChannel : VersionChannel.values()) {
            if (versionChannel.getChannelString().equals(channelString)) {
                return versionChannel.getChannel();
            }
        }
        throw new RuntimeException("没有查询到渠道号" + channelString);
    }

    public static boolean isNeedCdkey(String channelString) {
        return channelString.startsWith(VersionChannel.YYSC_CC.getChannelString());
    }
}
