package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Create by yuanwei
 * at 2018/8/14 0014 下午 16:55
 */
public class YoutuiHotAirticleDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 热文id
     */
    private Long id;

    /**
     * 是否删除，0：未删除，1：已删除
     */
    private Integer isDeleted;

    /**
     * 热文标题
     */
    private String title;

    /**
     * 热文内容
     */
    private String titleContext;

    /**
     * 热文标签
     */
    private String tag;

    /**
     * 热文来源，0：手工，1:趣闻，2:微小宝
     */
    private Integer textSource;

    /**
     * 是否推荐，0：未推荐，1：已推荐
     */
    private Integer isRecommend;

    /**
     * 热文url链接
     */
    private String url;

    /**
     * 热文默认评论
     */
    private List<DefaultComment> comments;

    /**
     * 入库时间
     */
    private String storageTime;

    /**
     * 是否发布，0：未发布，1：已发布
     */
    private Integer isPublish;

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 是否可以发布
     */
    private Integer isRealse;
    /**
     * 文章阅读数基准值
     */
    private Integer readCount;
    /**
     * 文章作者
     * @return
     */
    private String author;
    /**
     * 缩略图url
     */
    private String thumbnailUrl;
    /**
     * 是否存在默认缩略图
     */
    private Integer isHaveDefaultImg;

    public Integer getIsHaveDefaultImg() {
        return isHaveDefaultImg;
    }

    public void setIsHaveDefaultImg(Integer isHaveDefaultImg) {
        this.isHaveDefaultImg = isHaveDefaultImg;
    }

    public Integer getReadCount() {
        return readCount;
    }

    public void setReadCount(Integer readCount) {
        this.readCount = readCount;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Integer getIsRealse() {
        return isRealse;
    }

    public void setIsRealse(Integer isRealse) {
        this.isRealse = isRealse;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public void setTitleContext(String titleContext) {
        this.titleContext = titleContext;
    }

    public String getTitleContext() {
        return titleContext;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return tag;
    }

    public Integer getTextSource() {
        return textSource;
    }

    public void setTextSource(Integer textSource) {
        this.textSource = textSource;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return url;
    }

    public List<DefaultComment> getComments() {
        return comments;
    }

    public void setComments(List<DefaultComment> comments) {
        this.comments = comments;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public String getStorageTime() {
        return storageTime;
    }

    public void setStorageTime(String storageTime) {
        this.storageTime = storageTime;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @ApiModel("朋友圈热文默认评论")
    public static class DefaultComment implements Serializable {

        @ApiModelProperty("序号")
        private Integer i;

        @ApiModelProperty("内容")
        private String c;

        public Integer getI() {
            return i;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public String getC() {
            return c;
        }

        public void setC(String c) {
            this.c = c;
        }
    }
}
