package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

@ApiModel("拼多多商品Dto")
public class PDDGoodsDto extends BaseDto {
    @ApiModelProperty(value = "商品id")
    @JSONField(name="goods_id")
    private Long goodsId;

    @ApiModelProperty(value = "商品名称")
    @JSONField(name="goods_name")
    private String goodsName;

    @ApiModelProperty("商品缩略图")
    @JSONField(name="goods_thumbnail_url")
    private String goodsThumbnailUrl;

    @ApiModelProperty("商品主图")
    @JSONField(name="goods_image_url")
    private String goodsImageUrl;

    @ApiModelProperty("已售卖件数")
    @JSONField(name="sold_quantity")
    private Integer soldQuantity;

    @ApiModelProperty("最小拼团价格，单位为分")
    @JSONField(name="min_group_price")
    private Long minGroupPrice;

    @ApiModelProperty("最小单买价格，单位为分")
    @JSONField(name="min_normal_price")
    private Long minNormalPrice;

    @ApiModelProperty("店铺名称")
    @JSONField(name="mall_name")
    private String mallName;

    @ApiModelProperty("优惠券门槛价格，单位为分")
    @JSONField(name="coupon_min_order_amount")
    private Long couponMinOrderAmount;

    @ApiModelProperty("优惠券面额，单位为分")
    @JSONField(name="coupon_discount")
    private Long couponDiscount;

    @ApiModelProperty("优惠券总数量")
    @JSONField(name="coupon_total_quantity")
    private Integer couponTotalQuantity;

    @ApiModelProperty("优惠券剩余数量")
    @JSONField(name="coupon_remain_quantity")
    private Long couponRemainQuantity;

    @ApiModelProperty("优惠券生效时间，UNIX时间戳")
    @JSONField(name="coupon_start_time")
    private String couponStartTime;

    @ApiModelProperty("优惠券失效时间，UNIX时间戳")
    @JSONField(name="coupon_end_time")
    private String couponEndTime;

    @ApiModelProperty("佣金比例，千分比")
    @JSONField(name="promotion_rate")
    private String promotionRate;

    @ApiModelProperty("商品评价分")
    @JSONField(name="goods_eval_score")
    private String goodsEvalScore;

    @ApiModelProperty("商品评价数量")
    @JSONField(name="goods_eval_count")
    private String goodsEvalCount;

    @ApiModelProperty("商品类目ID,','隔开")
    @JSONField(name="cat_ids")
    private List<Integer> catIds;

    @ApiModelProperty("商品类目,','隔开")
    private String catIdsStr;

    @ApiModelProperty("商品标签ID，格式为：[一级标签ID，二级标签ID，三级标签ID...]")
    @JSONField(name="opt_id")
    private Integer optId;

    @ApiModelProperty("商品标签名")
    @JSONField(name="opt_name")
    private String optName;

    @ApiModelProperty("商品详情图列表")
    @JSONField(name="goods_gallery_urls")
    private List<String> goodsGalleryUrls;

    @ApiModelProperty("描述评分")
    @JSONField(name="avg_desc")
    private Long avgDesc;

    @ApiModelProperty("物流评分")
    @JSONField(name="avg_lgst")
    private Long avgLgst;

    @ApiModelProperty("服务评分")
    @JSONField(name="avg_serv")
    private Long avgServ;

    @ApiModelProperty("店铺类型，1-个人，2-企业，3-旗舰店，4-专卖店，5-专营店，6-普通店")
    @JSONField(name="merchant_type")
    private Integer merchantType;

    @ApiModelProperty("商品标签ID,'',''隔开'")
    @JSONField(name="opt_ids")
    private List<Integer> optIds;

    @ApiModelProperty("描述评分击败同类店铺百分比")
    @JSONField(name="desc_pct")
    private String descPct;

    @ApiModelProperty("物流评分击败同类店铺百分比")
    @JSONField(name="lgst_pct")
    private String lgstPct;

    @ApiModelProperty("服务评分击败同类店铺百分比")
    @JSONField(name="serv_pct")
    private String servPct;

    @ApiModelProperty("上架状态（0：未上架；1：已上架）")
    private Integer isPublish;
    @ApiModelProperty("商品权重")
    private Integer rate;

    //上一次的同步时间
    private Date synDate;


    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public String getCatIdsStr() {
        return catIdsStr;
    }

    public void setCatIdsStr(String catIdsStr) {
        this.catIdsStr = catIdsStr;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getGoodsThumbnailUrl() {
        return goodsThumbnailUrl;
    }

    public void setGoodsThumbnailUrl(String goodsThumbnailUrl) {
        this.goodsThumbnailUrl = goodsThumbnailUrl;
    }

    public String getGoodsImageUrl() {
        return goodsImageUrl;
    }

    public void setGoodsImageUrl(String goodsImageUrl) {
        this.goodsImageUrl = goodsImageUrl;
    }

    public Integer getSoldQuantity() {
        return soldQuantity;
    }

    public void setSoldQuantity(Integer soldQuantity) {
        this.soldQuantity = soldQuantity;
    }

    public Long getMinGroupPrice() {
        return minGroupPrice;
    }

    public void setMinGroupPrice(Long minGroupPrice) {
        this.minGroupPrice = minGroupPrice;
    }

    public Long getMinNormalPrice() {
        return minNormalPrice;
    }

    public void setMinNormalPrice(Long minNormalPrice) {
        this.minNormalPrice = minNormalPrice;
    }

    public String getMallName() {
        return mallName;
    }

    public void setMallName(String mallName) {
        this.mallName = mallName;
    }

    public Long getCouponMinOrderAmount() {
        return couponMinOrderAmount;
    }

    public void setCouponMinOrderAmount(Long couponMinOrderAmount) {
        this.couponMinOrderAmount = couponMinOrderAmount;
    }

    public Long getCouponDiscount() {
        return couponDiscount;
    }

    public void setCouponDiscount(Long couponDiscount) {
        this.couponDiscount = couponDiscount;
    }

    public Integer getCouponTotalQuantity() {
        return couponTotalQuantity;
    }

    public void setCouponTotalQuantity(Integer couponTotalQuantity) {
        this.couponTotalQuantity = couponTotalQuantity;
    }

    public Long getCouponRemainQuantity() {
        return couponRemainQuantity;
    }

    public void setCouponRemainQuantity(Long couponRemainQuantity) {
        this.couponRemainQuantity = couponRemainQuantity;
    }

    public String getCouponStartTime() {
        return couponStartTime;
    }

    public void setCouponStartTime(String couponStartTime) {
        this.couponStartTime = couponStartTime;
    }

    public String getCouponEndTime() {
        return couponEndTime;
    }

    public void setCouponEndTime(String couponEndTime) {
        this.couponEndTime = couponEndTime;
    }

    public String getPromotionRate() {
        return promotionRate;
    }

    public void setPromotionRate(String promotionRate) {
        this.promotionRate = promotionRate;
    }

    public String getGoodsEvalScore() {
        return goodsEvalScore;
    }

    public void setGoodsEvalScore(String goodsEvalScore) {
        this.goodsEvalScore = goodsEvalScore;
    }

    public String getGoodsEvalCount() {
        return goodsEvalCount;
    }

    public void setGoodsEvalCount(String goodsEvalCount) {
        this.goodsEvalCount = goodsEvalCount;
    }

    public List<Integer> getCatIds() {
        return catIds;
    }

    public void setCatIds(List<Integer> catIds) {
        this.catIds = catIds;
    }

    public Integer getOptId() {
        return optId;
    }

    public void setOptId(Integer optId) {
        this.optId = optId;
    }

    public String getOptName() {
        return optName;
    }

    public void setOptName(String optName) {
        this.optName = optName;
    }

    public List<String> getGoodsGalleryUrls() {
        return goodsGalleryUrls;
    }

    public void setGoodsGalleryUrls(List<String> goodsGalleryUrls) {
        this.goodsGalleryUrls = goodsGalleryUrls;
    }

    public Long getAvgDesc() {
        return avgDesc;
    }

    public void setAvgDesc(Long avgDesc) {
        this.avgDesc = avgDesc;
    }

    public Long getAvgLgst() {
        return avgLgst;
    }

    public void setAvgLgst(Long avgLgst) {
        this.avgLgst = avgLgst;
    }

    public Long getAvgServ() {
        return avgServ;
    }

    public void setAvgServ(Long avgServ) {
        this.avgServ = avgServ;
    }

    public Integer getMerchantType() {
        return merchantType;
    }

    public void setMerchantType(Integer merchantType) {
        this.merchantType = merchantType;
    }

    public List<Integer> getOptIds() {
        return optIds;
    }

    public void setOptIds(List<Integer> optIds) {
        this.optIds = optIds;
    }

    public String getDescPct() {
        return descPct;
    }

    public void setDescPct(String descPct) {
        this.descPct = descPct;
    }

    public String getLgstPct() {
        return lgstPct;
    }

    public void setLgstPct(String lgstPct) {
        this.lgstPct = lgstPct;
    }

    public String getServPct() {
        return servPct;
    }

    public void setServPct(String servPct) {
        this.servPct = servPct;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public Integer getRate() {
        return rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public Date getSynDate() {
        return synDate;
    }

    public void setSynDate(Date synDate) {
        this.synDate = synDate;
    }
}
