package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiCdkeyDto;

/**
 * 趣晒邀请码的remote业务
 * @author lichao 2018/7/24
 */
@AdvancedFeignClient
public interface RemoteCdkeyService {

    /**
     * 获取某个人的cdkey
     * @param dto
     * @return
     */
    YoutuiCdkeyDto findByAccount(YoutuiCdkeyDto dto);


    /**
     * 新生成cdkey
     * @param dto
     * @return
     */
    Boolean insertCdkey(YoutuiCdkeyDto dto);

    /**
     *
     * @param cdkey
     * @param amount
     * @return
     */
    Boolean updateMoney(String cdkey,Long amount,Integer cdkeyMoneyType);

    /**
     * 更新
     * @param cdkey cdk
     * @param amount 提现金额
     * @param cdkeyMoneyType 金额类型
     * @param cdkeyUpMoney 提现门槛金额
     * @return
     */
    Boolean updateMoneyAndUpMoney(String cdkey,Long amount,Integer cdkeyMoneyType,Long cdkeyUpMoney);

    /**
     * 使用cdkey,将cdkey
     * @param cdkey
     * @param userId
     * @return
     */
    YoutuiCdkeyDto useCdkey(String cdkey,Long userId);

    /**
     * 通过使用者id查询cdkey
     */
    YoutuiCdkeyDto getByUseConsumerId(Long consumerId);

    /**
     * 获取使用者提现上限
     * @param userId
     * @return
     */
    Long getMoneyUpper(Long userId);

}
