package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel("获得拼多多商品标签列表（非商品类目cat，当前仅开放给多多客使用）")
public class PDDGoodsOptDto extends BaseDto {

    @ApiModelProperty("类目级别")
    private Integer level;

    @ApiModelProperty("父类目ID，0时为顶级节点")
    private Long parentOptId;

    @ApiModelProperty("类目名称")
    private String optName;

    @ApiModelProperty("类目ID")
    private Long optId;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PDDGoodsOptDto that = (PDDGoodsOptDto) o;
        return Objects.equals(level, that.level) &&
                Objects.equals(parentOptId, that.parentOptId) &&
                Objects.equals(optName, that.optName) &&
                Objects.equals(optId, that.optId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(level, parentOptId, optName, optId);
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getOptName() {
        return optName;
    }

    public void setOptName(String optName) {
        this.optName = optName;
    }

    public Long getParentOptId() {
        return parentOptId;
    }

    public void setParentOptId(Long parentOptId) {
        this.parentOptId = parentOptId;
    }

    public Long getOptId() {
        return optId;
    }

    public void setOptId(Long optId) {
        this.optId = optId;
    }

    /**
     * 将返回的JSON Object转换为class
     * @return
     */
    public static List<PDDGoodsOptDto> jsonObjectToClass(JSONObject jsonObject) {
        List<PDDGoodsOptDto> list = new ArrayList<>();
        JSONObject goodsOptGetResponse = jsonObject.getJSONObject("goods_opt_get_response");
        JSONArray goodsOptList = goodsOptGetResponse.getJSONArray("goods_opt_list");
        for (Object goodsOpt : goodsOptList) {
            JSONObject goodsOptJSONObject = (JSONObject) goodsOpt;
            Integer level = goodsOptJSONObject.getInteger("level");
            Long optId = goodsOptJSONObject.getLong("opt_id");
            Long parentOptId = goodsOptJSONObject.getLong("parent_opt_id");
            String optName = goodsOptJSONObject.getString("opt_name");
            PDDGoodsOptDto dto = new PDDGoodsOptDto();
            dto.setOptId(optId);
            dto.setLevel(level);
            dto.setOptName(optName);
            dto.setParentOptId(parentOptId);
            list.add(dto);
        }
        return list;
    }

    @ApiModel("非商品类目请求参数")
    public static class PDDGoodsOptReq extends PDDBaseReq{
        @ApiModelProperty("父级类目ID")
        private Integer parent_opt_id;

        public Integer getParent_opt_id() {
            return parent_opt_id;
        }

        public void setParent_opt_id(Integer parent_opt_id) {
            this.parent_opt_id = parent_opt_id;
        }

        public PDDGoodsOptReq() {
            this.parent_opt_id = 0;
        }

        public PDDGoodsOptReq(Integer parent_opt_id) {
            this.parent_opt_id = parent_opt_id;
        }

        @Override
        public String getType() {
            return "pdd.goods.opt.get";
        }

        @Override
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("parent_opt_id",this.getParent_opt_id().toString());
            return paramsMap;
        }

        public static void main(String[] args) {
            PDDGoodsOptReq pddGoodsOptReq = new PDDGoodsOptReq();
            try {
                JSONObject request = pddGoodsOptReq.request();
                System.out.println();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }
}
