package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

@ApiModel("拼多多订单列表Dto")
public class PDDOrderListDto extends BaseDto{
    @ApiModelProperty("多多进宝推广位对象列表")
    private List<PddorderDetail> orderList;
    @ApiModelProperty("请求到的结果数")
    private Integer totalCount;

    public List<PddorderDetail> getOrderList() {
        return orderList;
    }

    public void setOrderList(List<PddorderDetail> orderList) {
        this.orderList = orderList;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    @ApiModel("拼多多订单详情")
    public static class PddorderDetail{
        @ApiModelProperty(value = "订单确认签收时间")
        private Long orderReceiveTime;
        @ApiModelProperty(value = "自定义参数，标志订单来源于哪个自定义参数")
        private String customParameters;
        @ApiModelProperty(value = "订单来源：0-单品（领券页）推广，1-红包活动推广，2-领券页底部推荐，54-大转盘主页的商品，55-抽中免单的商品，56-大转盘抽中红包的商品，13-大转盘拉新锁佣的")
        private Integer type;
        @ApiModelProperty(value = "审核时间")
        private Long orderVerifyTime;
        @ApiModelProperty(value = "支付时间")
        private Long orderPayTime;
        @ApiModelProperty(value = "成团时间")
        private Long orderGroupSuccessTime;
        @ApiModelProperty(value = "最后更新时间")
        private Long orderModifyAt;
        @ApiModelProperty(value = "订单状态描述")
        private String orderStatusDesc;
        @ApiModelProperty(value = "推广位ID")
        private String pId;
        @ApiModelProperty(value = "订单状态： -1 未支付; 0-已支付；1-已成团；2-确认收货；3-审核成功；4-审核失败（不可提现）；5-已经结算；8-非多多进宝商品（无佣金订单）;10-已处罚")
        private Integer orderStatus;
        @ApiModelProperty(value = "佣金金额，单位为分")
        private Integer promotionAmount;
        @ApiModelProperty(value = "佣金比例，千分比")
        private Integer promotionRate;
        @ApiModelProperty(value = "订单生成时间，UNIX时间戳")
        private Long orderCreateTime;
        @ApiModelProperty(value = "实际支付金额，单位为分")
        private Integer orderAmount;
        @ApiModelProperty(value = "订单中sku的单件价格，单位为分")
        private Integer goodsPrice;
        @ApiModelProperty(value = "购买商品的数量")
        private Integer goodsQuantity;
        @ApiModelProperty(value = "商品缩略图")
        private String goodsThumbnailUrl;
        @ApiModelProperty(value = "商品标题")
        private String goodsName;
        @ApiModelProperty(value = "商品ID")
        private Long goodsId;
        @ApiModelProperty(value = "推广订单编号")
        private String orderSn;

        public Long getOrderReceiveTime() {
            return orderReceiveTime;
        }

        public void setOrderReceiveTime(Long orderReceiveTime) {
            this.orderReceiveTime = orderReceiveTime;
        }

        public String getCustomParameters() {
            return customParameters;
        }

        public void setCustomParameters(String customParameters) {
            this.customParameters = customParameters;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Long getOrderVerifyTime() {
            return orderVerifyTime;
        }

        public void setOrderVerifyTime(Long orderVerifyTime) {
            this.orderVerifyTime = orderVerifyTime;
        }

        public Long getOrderPayTime() {
            return orderPayTime;
        }

        public void setOrderPayTime(Long orderPayTime) {
            this.orderPayTime = orderPayTime;
        }

        public Long getOrderGroupSuccessTime() {
            return orderGroupSuccessTime;
        }

        public void setOrderGroupSuccessTime(Long orderGroupSuccessTime) {
            this.orderGroupSuccessTime = orderGroupSuccessTime;
        }

        public Long getOrderModifyAt() {
            return orderModifyAt;
        }

        public void setOrderModifyAt(Long orderModifyAt) {
            this.orderModifyAt = orderModifyAt;
        }

        public String getOrderStatusDesc() {
            return orderStatusDesc;
        }

        public void setOrderStatusDesc(String orderStatusDesc) {
            this.orderStatusDesc = orderStatusDesc;
        }

        public String getpId() {
            return pId;
        }

        public void setpId(String pId) {
            this.pId = pId;
        }

        public Integer getOrderStatus() {
            return orderStatus;
        }

        public void setOrderStatus(Integer orderStatus) {
            this.orderStatus = orderStatus;
        }

        public Integer getPromotionAmount() {
            return promotionAmount;
        }

        public void setPromotionAmount(Integer promotionAmount) {
            this.promotionAmount = promotionAmount;
        }

        public Integer getPromotionRate() {
            return promotionRate;
        }

        public void setPromotionRate(Integer promotionRate) {
            this.promotionRate = promotionRate;
        }

        public Long getOrderCreateTime() {
            return orderCreateTime;
        }

        public void setOrderCreateTime(Long orderCreateTime) {
            this.orderCreateTime = orderCreateTime;
        }

        public Integer getOrderAmount() {
            return orderAmount;
        }

        public void setOrderAmount(Integer orderAmount) {
            this.orderAmount = orderAmount;
        }

        public Integer getGoodsPrice() {
            return goodsPrice;
        }

        public void setGoodsPrice(Integer goodsPrice) {
            this.goodsPrice = goodsPrice;
        }

        public Integer getGoodsQuantity() {
            return goodsQuantity;
        }

        public void setGoodsQuantity(Integer goodsQuantity) {
            this.goodsQuantity = goodsQuantity;
        }

        public String getGoodsThumbnailUrl() {
            return goodsThumbnailUrl;
        }

        public void setGoodsThumbnailUrl(String goodsThumbnailUrl) {
            this.goodsThumbnailUrl = goodsThumbnailUrl;
        }

        public String getGoodsName() {
            return goodsName;
        }

        public void setGoodsName(String goodsName) {
            this.goodsName = goodsName;
        }

        public Long getGoodsId() {
            return goodsId;
        }

        public void setGoodsId(Long goodsId) {
            this.goodsId = goodsId;
        }

        public String getOrderSn() {
            return orderSn;
        }

        public void setOrderSn(String orderSn) {
            this.orderSn = orderSn;
        }
    }

    @ApiModel("拼多多订单列表查询参数")
    public static class PddOrderListReq extends PDDBaseReq{
        @ApiModelProperty(value = "最近90天内多多进宝商品订单更新时间--查询时间开始。note：此时间为时间戳，指格林威治时间 1970 年01 月 01 日 00 时 00 分 00 秒(北京时间 1970 年 01 月 01 日 08 时 00 分 00 秒)起至现在的总秒数")
        private Long start_update_time;
        @ApiModelProperty(value = "最近90天内多多进宝商品订单更新时间--查询时间结束。note：此时间为时间戳，指格林威治时间 1970 年01 月 01 日 00 时 00 分 00 秒(北京时间 1970 年 01 月 01 日 08 时 00 分 00 秒)起至现在的总秒数")
        private Long end_update_time;
        @ApiModelProperty(value = "推广位ID")
        private String p_id;
        @ApiModelProperty(value = "返回的每页结果订单数，默认为100，范围为10到100，建议使用40~50，可以提高成功率，减少超时数量。")
        private Integer page_size;
        @ApiModelProperty(value = "第几页，从1到10000，默认1，注：使用最后更新时间范围增量同步时，必须采用倒序的分页方式（从最后一页往回取）才能避免漏单问题。")
        private Integer page;

        public Long getStart_update_time() {
            return start_update_time;
        }

        public void setStart_update_time(Long start_update_time) {
            this.start_update_time = start_update_time;
        }

        public Long getEnd_update_time() {
            return end_update_time;
        }

        public void setEnd_update_time(Long end_update_time) {
            this.end_update_time = end_update_time;
        }

        public String getP_id() {
            return p_id;
        }

        public void setP_id(String p_id) {
            this.p_id = p_id;
        }

        public Integer getPage_size() {
            return page_size;
        }

        public void setPage_size(Integer page_size) {
            this.page_size = page_size;
        }

        public Integer getPage() {
            return page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public PddOrderListReq() {}


        @Override
        public String getType() {
            return "pdd.ddk.order.list.increment.get";
        }

        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("start_update_time",this.getStart_update_time().toString());
            paramsMap.put("end_update_time",this.getEnd_update_time().toString());
            if(StringUtils.isNotBlank(this.getP_id())){
                paramsMap.put("p_id",this.getP_id());
            }
            if(null != this.getPage_size()){
                paramsMap.put("page_size",this.getPage_size().toString());
            }
            if(null != this.getPage()){
                paramsMap.put("page",this.getPage().toString());
            }
            return paramsMap;

        }

        public static void main(String[] args) throws Exception {
            PddOrderListReq pddOrderListReq = new PddOrderListReq();
            pddOrderListReq.setStart_update_time(1523965641L);
            pddOrderListReq.setEnd_update_time(1623966641L);
            JSONObject request = pddOrderListReq.request();
            System.err.println(request.toJSONString());

        }
    }

}
