package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PDDThemeDto extends BaseDto {

    /**
     * 返回的元素数量
     */
    private Integer total;

    /**
     * 返回的主题列表
     */
    private List<Theme> themeList;

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public List<Theme> getThemeList() {
        return themeList;
    }

    public void setThemeList(List<Theme> themeList) {
        this.themeList = themeList;
    }

    /**
     * 返回的主题列表信息
     */
    public static class Theme {
        /**
         * 主题ID
         */
        private Long themeId;
        /**
         * 主题图片
         */
        private String imageUrl;
        /**
         * 主题名称
         */
        private String name;
        /**
         * 主题包含的商品数量
         */
        private String goodsNum;

        public Long getThemeId() {
            return themeId;
        }

        public void setThemeId(Long themeId) {
            this.themeId = themeId;
        }

        public String getImageUrl() {
            return imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGoodsNum() {
            return goodsNum;
        }

        public void setGoodsNum(String goodsNum) {
            this.goodsNum = goodsNum;
        }
    }

    /**
     * 请求主题的参数
     */
    public static class Req extends PDDBaseReq {

        /**
         * 返回的一页数据数量
         */
        private Integer pageSize;

        /**
         * 返回的页码
         */
        private Integer page;

        @Override
        public String getType() {
            return "pdd.ddk.theme.list.get";
        }

        public Integer getPageSize() {
            return pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPage() {
            return page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        /**
         * 生成加密参数MAP
         *
         * @return
         */
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            if (this.getPageSize() != null) {
                paramsMap.put("page_size", this.getPageSize().toString());
            }

            if (this.getPage() != null) {
                paramsMap.put("page", this.getPage().toString());
            }

            return paramsMap;
        }
    }

    /**
     * 将返回的JSON Object转换为class
     * @return
     */
    public static PDDThemeDto jsonObjectToClass(JSONObject jsonObject) {
        PDDThemeDto pddThemeDto = new PDDThemeDto();
        JSONObject themeListGetResponse = jsonObject.getJSONObject("theme_list_get_response");
        Integer total = themeListGetResponse.getInteger("total");
        JSONArray themeList = themeListGetResponse.getJSONArray("theme_list");
        List<Theme> themes = new ArrayList<>(themeList.size());
        for (Object themeInfo : themeList) {
            JSONObject jsonInfo = (JSONObject) themeInfo;
            Theme theme = new Theme();
            theme.setImageUrl(jsonInfo.getString("image_url"));
            theme.setName(jsonInfo.getString("name"));
            theme.setGoodsNum(jsonInfo.getString("goods_num"));
            theme.setThemeId(jsonInfo.getLong("id"));
            themes.add(theme);
        }
        pddThemeDto.setThemeList(themes);
        pddThemeDto.setTotal(total);
        return pddThemeDto;
    }

    public static void main(String[] args) throws Exception {
        Req req = new Req();
        req.setPageSize(3);
        req.setPage(1);
        JSONObject request = req.request();
        PDDThemeDto pddThemeDto = PDDThemeDto.jsonObjectToClass(request);
        System.out.println(request);
    }
}

