package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDGoodsDto;

import java.util.Date;
import java.util.List;

/**
 * 拼多多商品的service
 * @author lichao 2018/9/12
 */
@AdvancedFeignClient
public interface RemotePDDGoodService {

    /**
     * 通过id查询库里面已经有的id
     * @param ids
     */
    List<Long> selectSkuByIds(List<Long> ids);

    /**
     * 插入sku
     */
    void insertSkus(List<PDDGoodsDto> dtos);

    /**
     * 通过上一次同步时间来进行查询
     * @param date
     * @return
     */
    List<PDDGoodsDto> selectSkuBySynTime(Date date);
}
