package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.PDDGoodsQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.req.PDDOrderQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqPageQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDGoodsCatDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDGoodsDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDGoodsOptDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDOrderDto;

import java.util.List;

/**
 * Create by yuanwei
 * at 2018/9/12 0012 上午 10:44
 */
@AdvancedFeignClient
public interface RemotePDDManagerService {
    /**
     * 获取拼多多商品类目列表
     * @return
     */
    PageDto<PDDGoodsCatDto> getPddGoodsCats(ReqPageQuery query);

    /**
     * 获取拼多多商品列表
     * @param query
     * @return
     */
    PageDto<PDDGoodsDto> getPddGoods(PDDGoodsQuery query);

    /**
     * 获取拼多多订单列表
     * @param query
     * @return
     */
    PageDto<PDDOrderDto> getPddOrders(PDDOrderQuery query);

    /**
     * 修改商品类目上下架
     * @param id
     * @param isPublish
     * @return
     */
    Boolean updateGoodsCatIsPublish(Long id,Integer isPublish);

    /**
     * 修改商品上下架
     * @param id
     * @param isPublish
     * @return
     */
    Boolean updateGoodsIsPublish(Long id,Integer isPublish);

    /**
     * 修改商品权重
     * @param id
     * @param rate
     * @return
     */
    Boolean updateGoodsRate(Long id,Integer rate);

    /**
     * 查询所有的类目
     * @return
     */
    List<PDDGoodsCatDto> selectAllCat();

    /**
     * 插入新类目
     * @param list
     * @return
     */
    Integer insertCat(List<PDDGoodsCatDto> list);

    /**
     * 删除过期的类目
     * @param ids
     * @return
     */
    Integer deleteCatByIds(List<Long> ids);

    /**
     * 查询所有的标签
     * @return
     */
    List<PDDGoodsOptDto> selectAllOpt();

    /**
     * 查询所有上架的标签
     * @return
     */
    List<PDDGoodsOptDto> selectAllPublishOpt();

    /**
     * 插入新的标签
     * @param list
     * @return
     */
    Integer insertOpt(List<PDDGoodsOptDto> list);

    /**
     * 删除过期类目
     * @param ids
     * @return
     */
    Integer deleteOptByIds(List<Long> ids);

    /**
     * 查询最后一笔订单
     * @param userId
     * @return
     */
    PDDOrderDto selectLastOrder(Long userId);
}
