/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDBaseReq;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PDDThemeDto
extends BaseDto {
    private Integer total;
    private List<Theme> themeList;

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public List<Theme> getThemeList() {
        return this.themeList;
    }

    public void setThemeList(List<Theme> themeList) {
        this.themeList = themeList;
    }

    public static PDDThemeDto jsonObjectToClass(JSONObject jsonObject) {
        PDDThemeDto pddThemeDto = new PDDThemeDto();
        JSONObject themeListGetResponse = jsonObject.getJSONObject("theme_list_get_response");
        Integer total = themeListGetResponse.getInteger("total");
        JSONArray themeList = themeListGetResponse.getJSONArray("theme_list");
        ArrayList<Theme> themes = new ArrayList<Theme>(themeList.size());
        for (Object themeInfo : themeList) {
            JSONObject jsonInfo = (JSONObject)themeInfo;
            Theme theme = new Theme();
            theme.setImageUrl(jsonInfo.getString("image_url"));
            theme.setName(jsonInfo.getString("name"));
            theme.setGoodsNum(jsonInfo.getString("goods_num"));
            theme.setThemeId(jsonInfo.getLong("id"));
            themes.add(theme);
        }
        pddThemeDto.setThemeList(themes);
        pddThemeDto.setTotal(total);
        return pddThemeDto;
    }

    public static void main(String[] args) throws Exception {
        Req req = new Req();
        req.setPageSize(3);
        req.setPage(1);
        JSONObject request = req.request();
        PDDThemeDto pddThemeDto = PDDThemeDto.jsonObjectToClass(request);
        System.out.println(request);
    }

    public static class Req
    extends PDDBaseReq {
        private Integer pageSize;
        private Integer page;

        @Override
        public String getType() {
            return "pdd.ddk.theme.list.get";
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            if (this.getPageSize() != null) {
                paramsMap.put("page_size", this.getPageSize().toString());
            }
            if (this.getPage() != null) {
                paramsMap.put("page", this.getPage().toString());
            }
            return paramsMap;
        }
    }

    public static class Theme {
        private Long themeId;
        private String imageUrl;
        private String name;
        private String goodsNum;

        public Long getThemeId() {
            return this.themeId;
        }

        public void setThemeId(Long themeId) {
            this.themeId = themeId;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGoodsNum() {
            return this.goodsNum;
        }

        public void setGoodsNum(String goodsNum) {
            this.goodsNum = goodsNum;
        }
    }
}

