package cn.com.duiba.tuia.youtui.center.api.constant;

public enum GameFrom {

    F1(1, null, null, "三级竞猜", null, "玩主", ""),
    DEFAULT(0, null, null, "猜猜乐", null, "自研", "吃鸡大作战");

    /**
     * 来源状态
     */
    private Integer origin;


    /**
     * 泡泡堂游戏描述
     */
    private String desc1;


    /**
     * 拼图游戏描述
     */
    private String desc2;

    /**
     * 押注游戏描述
     */
    private String desc3;

    /**
     * 挤肥皂描述
     */
    private String desc4;

    /**
     * 外部游戏描述
     */
    private String desc5;

    /**
     * 对战类游戏描述
     */
    private String desc6;

    GameFrom(Integer origin, String desc1, String desc2, String desc3, String desc4, String desc5, String desc6) {
        this.origin = origin;
        this.desc1 = desc1;
        this.desc2 = desc2;
        this.desc3 = desc3;
        this.desc4 = desc4;
        this.desc5 = desc5;
        this.desc6 = desc6;
    }

    public Integer getOrigin() {
        return origin;
    }

    public void setOrigin(Integer origin) {
        this.origin = origin;
    }

    public String getDesc1() {
        return desc1;
    }

    public void setDesc1(String desc1) {
        this.desc1 = desc1;
    }

    public String getDesc2() {
        return desc2;
    }

    public void setDesc2(String desc2) {
        this.desc2 = desc2;
    }

    public String getDesc3() {
        return desc3;
    }

    public void setDesc3(String desc3) {
        this.desc3 = desc3;
    }

    public String getDesc4() {
        return desc4;
    }

    public void setDesc4(String desc4) {
        this.desc4 = desc4;
    }

    public String getDesc5() {
        return desc5;
    }

    public void setDesc5(String desc5) {
        this.desc5 = desc5;
    }

    public String getDesc6() {
        return desc6;
    }

    public void setDesc6(String desc6) {
        this.desc6 = desc6;
    }

    /**
     * @param origin 　对应数据库中的gameFrom字段
     * @return
     */
    public static GameFrom getGameFrom(Integer origin) {
        for (GameFrom gameFrom : GameFrom.values()) {
            if (gameFrom.getOrigin().equals(origin)) {
                return gameFrom;
            }
        }
        return DEFAULT;
    }

    public static String getDesc(GameFrom gameFrom, Integer gameType) {
        String result;
        switch (gameType) {
            case 1:
                result = gameFrom.getDesc1();
                break;
            case 2:
                result = gameFrom.getDesc2();
                break;
            case 3:
                result = gameFrom.getDesc3();
                break;
            case 4:
                result = gameFrom.getDesc4();
                break;
            case 5:
                result = gameFrom.getDesc5();
                break;
            case 6:
                result = gameFrom.getDesc6();
                break;
            default:
                result = "";
        }
        return result;
    }
}
