package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.UserGameInfoDto;

/**
 * 游戏玩家最佳记录服务（最佳得分，解锁关卡）
 */
@AdvancedFeignClient
public interface RemoteUserGameInfoService {
    /**
     * 插入一条记录，extInfo放入需要的字段，userId和gameId和extInfo不能为空
     */
    Integer insert(UserGameInfoDto userGameInfoDto);

    /**
     * 更新一条记录，userId和gameId和extInfo不能为空
     */
    Integer update(UserGameInfoDto userGameInfoDto);

    /**
     * 查询用户最佳历史记录
     */
    UserGameInfoDto selectByUserId(Long userId, Long gameId);
}
