package cn.com.duiba.tuia.youtui.center.api.dto.youtui.groupSign;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import cn.com.duiba.tuia.youtui.center.api.util.SignKeywordUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel("群签到Dto")
public class YoutuiGroupSignDto extends BaseDto {

    @ApiModelProperty("用户标识")
    private String unionId;

    @ApiModelProperty("用户签到次数")
    private Integer signTimes;

    @ApiModelProperty("用户最后一次签到日期时间戳，当天0点")
    private Long signDate;

    @ApiModelProperty("用户昵称")
    private String userName;

    @ApiModelProperty("用户头像")
    private String userImg;

    private String openId;

    private List<String> formIds;

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public List<String> getFormIds() {
        return formIds;
    }

    public void setFormIds(List<String> formIds) {
        this.formIds = formIds;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public Integer getSignTimes() {
        return signTimes;
    }

    public void setSignTimes(Integer signTimes) {
        this.signTimes = signTimes;
    }

    public Long getSignDate() {
        return signDate;
    }

    public void setSignDate(Long signDate) {
        this.signDate = signDate;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserImg() {
        return userImg;
    }

    public void setUserImg(String userImg) {
        this.userImg = userImg;
    }

    @ApiModel("群签到rsp")
    public static class GroupSignRsp implements Serializable {

        @ApiModelProperty("用户签到次数")
        private Integer signTimes;

        @ApiModelProperty("用户最后一次签到日期时间戳，当天0点")
        private Long signDate;

        @ApiModelProperty("用户最后一次签到日期('yyyy-MM-dd')")
        private String signDateStr;

        @ApiModelProperty("当日签到关键字")
        private SignKeywordUtil.SignKeyword todayKeyword;

        @ApiModelProperty("昨日签到关键字")
        private SignKeywordUtil.SignKeyword yesKeyword;

        @ApiModelProperty("用户标识")
        private String unionId;

        @ApiModelProperty("群排名")
        private Integer groupRank;

        private String openId;

        private int show;

        public int getShow() {
            return show;
        }

        public void setShow(int show) {
            this.show = show;
        }

        public Integer getGroupRank() {
            return groupRank;
        }

        public void setGroupRank(Integer groupRank) {
            this.groupRank = groupRank;
        }

        public String getUnionId() {
            return unionId;
        }

        public String getOpenId() {
            return openId;
        }

        public void setOpenId(String openId) {
            this.openId = openId;
        }

        public void setUnionId(String unionId) {
            this.unionId = unionId;
        }

        public SignKeywordUtil.SignKeyword getTodayKeyword() {
            return todayKeyword;
        }

        public void setTodayKeyword(SignKeywordUtil.SignKeyword todayKeyword) {
            this.todayKeyword = todayKeyword;
        }

        public SignKeywordUtil.SignKeyword getYesKeyword() {
            return yesKeyword;
        }

        public void setYesKeyword(SignKeywordUtil.SignKeyword yesKeyword) {
            this.yesKeyword = yesKeyword;
        }

        public String getSignDateStr() {
            return signDateStr;
        }

        public void setSignDateStr(String signDateStr) {
            this.signDateStr = signDateStr;
        }

        public Integer getSignTimes() {
            return signTimes;
        }

        public void setSignTimes(Integer signTimes) {
            this.signTimes = signTimes;
        }

        public Long getSignDate() {
            return signDate;
        }

        public void setSignDate(Long signDate) {
            this.signDate = signDate;
        }

    }
}
